/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadOnlyVersionManager {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyVersionManager.class);

    @Nonnull
    protected abstract Tree getVersionStorage();

    @Nonnull
    protected abstract Root getWorkspaceRoot();

    @Nonnull
    protected abstract ReadOnlyNodeTypeManager getNodeTypeManager();

    @Nonnull
    public static ReadOnlyVersionManager getInstance(final Root root, final NamePathMapper namePathMapper) {
        return new ReadOnlyVersionManager(){

            @Override
            @Nonnull
            protected Tree getVersionStorage() {
                return root.getTree("/jcr:system/jcr:versionStorage");
            }

            @Override
            @Nonnull
            protected Root getWorkspaceRoot() {
                return root;
            }

            @Override
            @Nonnull
            protected ReadOnlyNodeTypeManager getNodeTypeManager() {
                return ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
            }
        };
    }

    public boolean isCheckedOut(@Nonnull Tree tree) {
        PropertyState p;
        if (Preconditions.checkNotNull(tree).exists() && (p = tree.getProperty("jcr:isCheckedOut")) != null) {
            return p.getValue(Type.BOOLEAN);
        }
        if (tree.isRoot()) {
            return true;
        }
        return this.isCheckedOut(tree.getParent());
    }

    @CheckForNull
    public Tree getVersionHistory(@Nonnull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        String uuid = versionable.getProperty("jcr:uuid").getValue(Type.STRING);
        return TreeUtil.getTree(this.getVersionStorage(), this.getVersionHistoryPath(uuid));
    }

    @CheckForNull
    public Tree getVersion(@Nonnull String uuid) {
        return this.getIdentifierManager().getTree(uuid);
    }

    @Nonnull
    public String getVersionHistoryPath(@Nonnull String uuid) {
        String relPath = "";
        for (int i = 0; i < 3; ++i) {
            String name = uuid.substring(i * 2, i * 2 + 2);
            relPath = PathUtils.concat(relPath, name);
        }
        return PathUtils.concat(relPath, uuid);
    }

    @CheckForNull
    public Tree getBaseVersion(@Nonnull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        PropertyState p = versionable.getProperty("jcr:baseVersion");
        if (p == null) {
            return null;
        }
        return this.getIdentifierManager().getTree(p.getValue(Type.STRING));
    }

    public static boolean isVersionStoreTree(@Nonnull Tree tree) {
        return "rep:versionStorage".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    @CheckForNull
    public Tree getVersionable(@Nonnull Tree versionTree, @Nonnull String workspaceName) {
        Root root = this.getWorkspaceRoot();
        String relPath = "";
        Tree t = versionTree;
        while (t.exists() && !ReadOnlyVersionManager.isVersionStoreTree(t) && !t.isRoot()) {
            String ntName = TreeUtil.getPrimaryTypeName(t);
            if ("nt:frozenNode".equals(ntName)) {
                relPath = PathUtils.relativize(t.getPath(), versionTree.getPath());
            } else if ("nt:versionHistory".equals(ntName)) {
                PropertyState prop = t.getProperty(workspaceName);
                if (prop != null) {
                    return root.getTree(PathUtils.concat(prop.getValue(Type.PATH), relPath));
                }
                log.warn("Missing versionable path property for {} at {}", (Object)workspaceName, (Object)t.getPath());
                break;
            }
            t = t.getParent();
        }
        return null;
    }

    protected IdentifierManager getIdentifierManager() {
        return new IdentifierManager(this.getWorkspaceRoot());
    }

    @Nonnull
    protected Tree checkVersionable(@Nonnull Tree tree) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isVersionable(Preconditions.checkNotNull(tree))) {
            throw new UnsupportedRepositoryOperationException("Node at " + tree.getPath() + " is not versionable");
        }
        return tree;
    }

    protected boolean isVersionable(@Nonnull Tree tree) {
        return this.getNodeTypeManager().isNodeType(Preconditions.checkNotNull(tree), "mix:versionable");
    }

    boolean isVersionable(NodeState versionableCandidate) {
        return this.isVersionable(TreeFactory.createReadOnlyTree(versionableCandidate));
    }
}

