/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfo;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateNodeTypeInfoProvider
implements NodeTypeInfoProvider {
    private final NodeState types;

    public NodeStateNodeTypeInfoProvider(NodeState baseState) {
        this.types = baseState.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
    }

    public NodeTypeInfo getNodeTypeInfo(String nodeTypeName) {
        NodeState type = this.types.getChildNode(nodeTypeName);
        return new NodeStateNodeTypeInfo(type);
    }

    static class NodeStateNodeTypeInfo
    implements NodeTypeInfo {
        private final NodeState type;

        NodeStateNodeTypeInfo(NodeState type) {
            this.type = type;
        }

        public boolean exists() {
            return this.type.exists();
        }

        public String getNodeTypeName() {
            return this.type.getName("jcr:nodeTypeName");
        }

        public Set<String> getSuperTypes() {
            return Sets.newHashSet(this.type.getNames("rep:supertypes"));
        }

        public Set<String> getPrimarySubTypes() {
            return Sets.newHashSet(this.type.getNames("rep:primarySubtypes"));
        }

        public Set<String> getMixinSubTypes() {
            return Sets.newHashSet(this.type.getNames("rep:mixinSubtypes"));
        }

        public boolean isMixin() {
            return this.type.getBoolean("jcr:isMixin");
        }

        public Iterable<String> getNamesSingleValuesProperties() {
            return this.type.getNames("rep:namedSingleValuedProperties");
        }
    }
}

