/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Query Engine Settings Service", description="Various settings exposed by Oak QueryEngine. Note that settings done by system property supersedes the one defined via OSGi config")
public class QueryEngineSettingsService {
    private static final int DEFAULT_QUERY_LIMIT_IN_MEMORY = 500000;
    @Property(intValue={500000}, label="In memory limit", description="Maximum number of entries that can be held in memory while evaluating any query")
    static final String QUERY_LIMIT_IN_MEMORY = "queryLimitInMemory";
    private static final int DEFAULT_QUERY_LIMIT_READS = 100000;
    @Property(intValue={100000}, label="In memory read limit", description="Maximum number of results which can be read by any query")
    static final String QUERY_LIMIT_READS = "queryLimitReads";
    private static final boolean DEFAULT_QUERY_FAIL_TRAVERSAL = false;
    @Property(boolValue={false}, label="Fail traversal", description="If enabled any query execution which results in traversal would fail.")
    static final String QUERY_FAIL_TRAVERSAL = "queryFailTraversal";
    @Property(boolValue={false}, label="Fast result size", description="Whether the query result size should return an estimation (or -1 if disabled) for large queries")
    static final String QUERY_FAST_QUERY_SIZE = "fastQuerySize";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private QueryEngineSettingsMBean queryEngineSettings;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        if (System.getProperty("oak.queryLimitInMemory") == null) {
            int queryLimitInMemory = PropertiesUtil.toInteger(config.get(QUERY_LIMIT_IN_MEMORY), 500000);
            this.queryEngineSettings.setLimitInMemory(queryLimitInMemory);
        } else {
            this.logMsg(QUERY_LIMIT_IN_MEMORY, "oak.queryLimitInMemory");
        }
        if (System.getProperty("oak.queryLimitReads") == null) {
            int queryLimitReads = PropertiesUtil.toInteger(config.get(QUERY_LIMIT_READS), 100000);
            this.queryEngineSettings.setLimitReads(queryLimitReads);
        } else {
            this.logMsg(QUERY_LIMIT_IN_MEMORY, "oak.queryLimitReads");
        }
        if (System.getProperty("oak.queryFailTraversal") == null) {
            boolean failTraversal = PropertiesUtil.toBoolean(config.get(QUERY_FAIL_TRAVERSAL), false);
            this.queryEngineSettings.setFailTraversal(failTraversal);
        } else {
            this.logMsg(QUERY_FAIL_TRAVERSAL, "oak.queryFailTraversal");
        }
        boolean fastQuerySizeSysProp = QueryEngineSettings.DEFAULT_FAST_QUERY_SIZE;
        boolean fastQuerySizeFromConfig = PropertiesUtil.toBoolean(config.get(QUERY_FAST_QUERY_SIZE), false);
        this.queryEngineSettings.setFastQuerySize(fastQuerySizeFromConfig || fastQuerySizeSysProp);
        this.log.info("Initialize QueryEngine settings {}", (Object)this.queryEngineSettings);
    }

    private void logMsg(String key, String sysPropKey) {
        this.log.info("For {} using value {} defined via system property {}", new Object[]{key, System.getProperty(sysPropKey), sysPropKey});
    }

    protected void bindQueryEngineSettings(QueryEngineSettingsMBean queryEngineSettingsMBean) {
        this.queryEngineSettings = queryEngineSettingsMBean;
    }

    protected void unbindQueryEngineSettings(QueryEngineSettingsMBean queryEngineSettingsMBean) {
        if (this.queryEngineSettings == queryEngineSettingsMBean) {
            this.queryEngineSettings = null;
        }
    }
}

