/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;

public abstract class AbstractDataRecord
implements DataRecord {
    private final AbstractSharedBackend backend;
    private final DataIdentifier identifier;

    public AbstractDataRecord(AbstractSharedBackend backend, DataIdentifier identifier) {
        this.backend = backend;
        this.identifier = identifier;
    }

    @Override
    public DataIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getReference() {
        return this.backend.getReferenceFromIdentifier(this.identifier);
    }

    public String toString() {
        return this.identifier.toString();
    }

    public boolean equals(Object object) {
        return object instanceof DataRecord && this.identifier.equals(((DataRecord)object).getIdentifier());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

