/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CompositeObserver
implements Observer {
    private final Set<Observer> observers = Sets.newIdentityHashSet();

    public synchronized void addObserver(@Nonnull Observer observer) {
        Preconditions.checkState(this.observers.add(Preconditions.checkNotNull(observer)));
    }

    public synchronized void removeObserver(@Nonnull Observer observer) {
        Preconditions.checkState(this.observers.remove(Preconditions.checkNotNull(observer)));
    }

    @Override
    public synchronized void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        Preconditions.checkNotNull(root);
        for (Observer observer : this.observers) {
            observer.contentChanged(root, info);
        }
    }

    public synchronized String toString() {
        return this.observers.toString();
    }
}

