/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public abstract class DiffObserver
implements Observer {
    private NodeState before = null;

    protected abstract NodeStateDiff getRootDiff(@Nonnull NodeState var1, @Nonnull NodeState var2, @Nonnull CommitInfo var3);

    @Override
    public final synchronized void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        Preconditions.checkNotNull(root);
        if (this.before != null) {
            NodeStateDiff diff = this.getRootDiff(this.before, root, info);
            root.compareAgainstBaseState(this.before, diff);
        }
        this.before = root;
    }
}

