/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.spi.query.PropertyStateValue;

public final class PropertyValues {
    private PropertyValues() {
    }

    @CheckForNull
    public static PropertyValue create(@CheckForNull PropertyState property) {
        if (property == null) {
            return null;
        }
        return PropertyValues.newValue(property);
    }

    @Nonnull
    private static PropertyValue newValue(@Nonnull PropertyState property) {
        return new PropertyStateValue(property);
    }

    @CheckForNull
    public static PropertyState create(@CheckForNull PropertyValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PropertyStateValue) {
            return ((PropertyStateValue)value).unwrap();
        }
        return null;
    }

    @Nonnull
    public static PropertyValue newString(@Nonnull String value) {
        return new PropertyStateValue(StringPropertyState.stringProperty("", value));
    }

    @Nonnull
    public static PropertyValue newString(@Nonnull Iterable<String> value) {
        return new PropertyStateValue(MultiStringPropertyState.stringProperty("", value));
    }

    @Nonnull
    public static PropertyValue newLong(@Nonnull Long value) {
        return new PropertyStateValue(LongPropertyState.createLongProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDouble(@Nonnull Double value) {
        return new PropertyStateValue(DoublePropertyState.doubleProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDecimal(@Nonnull BigDecimal value) {
        return new PropertyStateValue(DecimalPropertyState.decimalProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBoolean(boolean value) {
        return new PropertyStateValue(BooleanPropertyState.booleanProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDate(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.dateProperty("", value));
    }

    @Nonnull
    public static PropertyValue newName(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.nameProperty("", value));
    }

    @Nonnull
    public static PropertyValue newName(@Nonnull Iterable<String> value) {
        return new PropertyStateValue(MultiGenericPropertyState.nameProperty("", value));
    }

    @Nonnull
    public static PropertyValue newPath(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.pathProperty("", value));
    }

    @Nonnull
    public static PropertyValue newReference(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.referenceProperty("", value));
    }

    @Nonnull
    public static PropertyValue newWeakReference(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.weakreferenceProperty("", value));
    }

    @Nonnull
    public static PropertyValue newUri(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.uriProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBinary(@Nonnull byte[] value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBinary(@Nonnull Blob value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    public static boolean match(@Nonnull PropertyValue p1, @Nonnull PropertyState p2) {
        return PropertyValues.match(p1, PropertyValues.newValue(p2));
    }

    public static boolean match(@Nonnull PropertyState p1, @Nonnull PropertyValue p2) {
        return PropertyValues.match(PropertyValues.newValue(p1), p2);
    }

    public static boolean match(@Nonnull PropertyValue p1, @Nonnull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return false;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains(p1.getValue(Type.BINARIES), p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains(p2.getValue(Type.BINARIES), p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains(p1.getValue(Type.STRINGS), p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains(p2.getValue(Type.STRINGS), p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo(p2) == 0;
    }

    public static boolean notMatch(@Nonnull PropertyValue p1, @Nonnull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return true;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains(p1.getValue(Type.BINARIES), p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains(p2.getValue(Type.BINARIES), p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains(p1.getValue(Type.STRINGS), p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains(p2.getValue(Type.STRINGS), p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo(p2) != 0;
    }

    public static PropertyValue convert(@Nonnull PropertyValue value, int targetType, @Nullable NamePathMapper mapper) {
        int sourceType = value.getType().tag();
        if (sourceType == targetType) {
            return value;
        }
        switch (targetType) {
            case 2: {
                Blob blob = value.getValue(Type.BINARY);
                return PropertyValues.newBinary(blob);
            }
            case 6: {
                return PropertyValues.newBoolean(value.getValue(Type.BOOLEAN));
            }
            case 5: {
                return PropertyValues.newDate(value.getValue(Type.DATE));
            }
            case 4: {
                return PropertyValues.newDouble(value.getValue(Type.DOUBLE));
            }
            case 3: {
                return PropertyValues.newLong(value.getValue(Type.LONG));
            }
            case 12: {
                return PropertyValues.newDecimal(value.getValue(Type.DECIMAL));
            }
        }
        String v = value.getValue(Type.STRING);
        switch (targetType) {
            case 1: {
                return PropertyValues.newString(v);
            }
            case 8: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 7: {
                        return PropertyValues.newPath(v);
                    }
                    case 11: {
                        URI uri = URI.create(v);
                        if (uri.isAbsolute()) {
                            throw new IllegalArgumentException("Failed to convert URI " + v + " to PATH");
                        }
                        String p = uri.getPath();
                        if (p.startsWith("./")) {
                            p = p.substring(2);
                        }
                        return PropertyValues.newPath(v);
                    }
                }
                break;
            }
            case 7: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 8: {
                        return PropertyValues.newName(PropertyValues.getOakPath(v, mapper));
                    }
                    case 11: {
                        URI uri = URI.create(v);
                        if (uri.isAbsolute()) {
                            throw new IllegalArgumentException("Failed to convert URI " + v + " to PATH");
                        }
                        String p = uri.getPath();
                        if (p.startsWith("./")) {
                            p = p.substring(2);
                        }
                        return PropertyValues.newName(PropertyValues.getOakPath(v, mapper));
                    }
                }
                break;
            }
            case 9: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 10: {
                        return PropertyValues.newReference(v);
                    }
                }
                break;
            }
            case 10: {
                switch (sourceType) {
                    case 1: 
                    case 2: 
                    case 9: {
                        return PropertyValues.newWeakReference(v);
                    }
                }
                break;
            }
            case 11: {
                switch (sourceType) {
                    case 1: 
                    case 2: {
                        return PropertyValues.newUri(v);
                    }
                    case 7: {
                        return PropertyValues.newUri("./" + v);
                    }
                    case 8: {
                        return PropertyValues.newUri("./" + v);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported conversion from property type " + PropertyType.nameFromValue((int)sourceType) + " to property type " + PropertyType.nameFromValue((int)targetType));
    }

    public static boolean canConvert(int sourceType, int targetType) {
        if (sourceType == targetType || sourceType == 0 || targetType == 0) {
            return true;
        }
        switch (targetType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return true;
            }
            case 7: 
            case 8: 
            case 11: {
                switch (sourceType) {
                    case 7: 
                    case 8: 
                    case 11: {
                        return true;
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                switch (sourceType) {
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
            }
        }
        return sourceType == 1 || sourceType == 2;
    }

    public static String getOakPath(@Nonnull String jcrPath, @CheckForNull NamePathMapper mapper) {
        if (mapper == null) {
            return jcrPath;
        }
        String p = mapper.getOakPath(jcrPath);
        if (p == null) {
            throw new IllegalArgumentException("Not a valid JCR path: " + jcrPath);
        }
        return p;
    }
}

