/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;

public abstract class ACE
implements JackrabbitAccessControlEntry {
    private final Principal principal;
    private final PrivilegeBits privilegeBits;
    private final boolean isAllow;
    private final Set<Restriction> restrictions;
    private final NamePathMapper namePathMapper;
    private int hashCode;

    public ACE(Principal principal, PrivilegeBits privilegeBits, boolean isAllow, Set<Restriction> restrictions, NamePathMapper namePathMapper) throws AccessControlException {
        if (principal == null || privilegeBits == null || privilegeBits.isEmpty()) {
            throw new AccessControlException();
        }
        this.principal = principal;
        this.privilegeBits = privilegeBits;
        this.isAllow = isAllow;
        this.restrictions = restrictions == null ? Collections.emptySet() : ImmutableSet.copyOf(restrictions);
        this.namePathMapper = namePathMapper;
    }

    @Nonnull
    public PrivilegeBits getPrivilegeBits() {
        return this.privilegeBits;
    }

    @Nonnull
    public Set<Restriction> getRestrictions() {
        return this.restrictions;
    }

    @Nonnull
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isAllow() {
        return this.isAllow;
    }

    @Override
    @Nonnull
    public String[] getRestrictionNames() throws RepositoryException {
        return Collections2.transform(this.restrictions, new Function<Restriction, String>(){

            @Override
            public String apply(Restriction restriction) {
                return ACE.this.getJcrName(restriction);
            }
        }).toArray(new String[this.restrictions.size()]);
    }

    @Override
    @CheckForNull
    public Value getRestriction(String restrictionName) throws RepositoryException {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            if (restriction.getDefinition().getRequiredType().isArray()) {
                List<Value> values = ValueFactoryImpl.createValues(restriction.getProperty(), this.namePathMapper);
                switch (values.size()) {
                    case 1: {
                        return values.get(0);
                    }
                }
                throw new ValueFormatException("Attempt to retrieve single value from multivalued property");
            }
            return ValueFactoryImpl.createValue(restriction.getProperty(), this.namePathMapper);
        }
        return null;
    }

    @Override
    @CheckForNull
    public Value[] getRestrictions(String restrictionName) throws RepositoryException {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            List<Value> values = ValueFactoryImpl.createValues(restriction.getProperty(), this.namePathMapper);
            return values.toArray(new Value[values.size()]);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode(this.principal.getName(), this.privilegeBits, this.isAllow, this.restrictions);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACE) {
            ACE other = (ACE)obj;
            return this.principal.getName().equals(other.principal.getName()) && this.isAllow == other.isAllow && this.privilegeBits.equals(other.privilegeBits) && this.restrictions.equals(other.restrictions);
        }
        return false;
    }

    private String getJcrName(Restriction restriction) {
        return this.namePathMapper.getJcrName(restriction.getDefinition().getName());
    }
}

