/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ZipFileArchive;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipArchive.class);
    private DefaultMetaInf inf;
    private int numEntries;
    private Archive base;
    private File zipFile;
    private final boolean isTempFile;

    public ZipArchive(File zipFile) {
        this(zipFile, false);
    }

    public ZipArchive(File zipFile, boolean isTempFile) {
        this.zipFile = zipFile;
        this.isTempFile = isTempFile;
    }

    @Override
    public void open(boolean strict) throws IOException {
        if (this.inf != null) {
            return;
        }
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.zipFile)));
        this.numEntries = 0;
        this.inf = new DefaultMetaInf();
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                ++this.numEntries;
                String name = entry.getName();
                if (!name.startsWith("META-INF/vault/")) continue;
                this.inf.load((InputStream)new CloseShieldInputStream((InputStream)zin), this.zipFile.getPath() + ":" + name);
            }
            if (this.inf.getFilter() == null) {
                log.debug("Zip {} does not contain filter definition.", (Object)this.zipFile.getPath());
            }
            if (this.inf.getConfig() == null) {
                log.debug("Zip {} does not contain vault config.", (Object)this.zipFile.getPath());
            }
            if (this.inf.getSettings() == null) {
                log.debug("Zip {} does not contain vault settings. using default.", (Object)this.zipFile.getPath());
                VaultSettings settings = new VaultSettings();
                settings.getIgnoredNames().add(".svn");
                this.inf.setSettings(settings);
            }
            if (this.inf.getProperties() == null) {
                log.debug("Zip {} does not contain properties.", (Object)this.zipFile.getPath());
            }
            if (this.inf.getNodeTypes().isEmpty()) {
                log.debug("Zip {} does not contain nodetypes.", (Object)this.zipFile.getPath());
            }
        }
        catch (IOException e) {
            log.error("Error while loading zip {}.", (Object)this.zipFile.getPath());
            throw e;
        }
        catch (ConfigurationException e) {
            log.error("Error while loading zip {}.", (Object)this.zipFile.getPath());
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zin);
        }
    }

    private Archive getBase() throws IOException {
        if (this.inf == null) {
            throw new IOException("Archive not open.");
        }
        if (this.base == null) {
            if (this.zipFile.length() > Integer.MAX_VALUE) {
                log.warn("ZipFile is larger than 2GB. Fallback to streaming archive.");
            } else {
                ZipFile zip = new ZipFile(this.zipFile, 1);
                if (zip.size() != this.numEntries) {
                    log.warn("ZipFile reports {} entries, but stream counts {} entries. Fallback to streaming archive.", (Object)String.valueOf(zip.size()), (Object)String.valueOf(this.numEntries));
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.base = new ZipFileArchive(zip);
                }
            }
            if (this.base == null) {
                this.base = new ZipStreamArchive(this.zipFile);
            }
            this.base.open(false);
        }
        return this.base;
    }

    @Override
    public MetaInf getMetaInf() {
        if (this.inf == null) {
            throw new IllegalStateException("Archive not open.");
        }
        return this.inf;
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.getBase().openInputStream(entry);
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return this.getBase().getInputSource(entry);
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return this.getBase().getRoot();
    }

    @Override
    public void close() {
        if (this.base != null) {
            this.base.close();
            this.base = null;
        }
        this.inf = null;
        if (this.zipFile != null && this.isTempFile) {
            FileUtils.deleteQuietly((File)this.zipFile);
        }
        this.zipFile = null;
    }

    public File getFile() {
        return this.zipFile;
    }

    public long getFileSize() {
        return this.zipFile == null ? -1L : this.zipFile.length();
    }

    public String toString() {
        return this.zipFile.getPath();
    }
}

