/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;

public interface JcrPackage
extends Comparable<JcrPackage> {
    public static final String NT_VLT_PACKAGE = "vlt:Package";
    public static final String NT_VLT_PACKAGE_DEFINITION = "vlt:PackageDefinition";
    public static final String NN_VLT_DEFINITION = "vlt:definition";
    public static final String MIME_TYPE = "application/zip";

    @CheckForNull
    public JcrPackageDefinition getDefinition() throws RepositoryException;

    public boolean isValid();

    @CheckForNull
    public Node getNode();

    public boolean isSealed();

    @Nonnull
    public VaultPackage getPackage() throws RepositoryException, IOException;

    public void extract(@Nonnull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    public void install(@Nonnull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    @Nonnull
    public PackageId[] extractSubpackages(@Nonnull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    @Nonnull
    public Dependency[] getUnresolvedDependencies() throws RepositoryException;

    @Nonnull
    public PackageId[] getResolvedDependencies() throws RepositoryException;

    @CheckForNull
    public JcrPackage snapshot(@Nonnull ExportOptions var1, boolean var2) throws RepositoryException, PackageException, IOException;

    @CheckForNull
    public JcrPackage getSnapshot() throws RepositoryException;

    public void uninstall(@Nonnull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    public boolean verifyId(boolean var1, boolean var2) throws RepositoryException;

    public boolean isInstalled() throws RepositoryException;

    public long getSize();

    public void close();

    @CheckForNull
    public Property getData() throws RepositoryException;

    @CheckForNull
    public Node getDefNode() throws RepositoryException;
}

