/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.spi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationFeedbackHandler
implements AuthenticationFeedbackHandler {
    public static boolean handleRedirect(HttpServletRequest request, HttpServletResponse response) {
        String redirect = DefaultAuthenticationFeedbackHandler.getValidatedRedirectTarget(request);
        if (redirect != null) {
            try {
                response.sendRedirect(redirect);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DefaultAuthenticationFeedbackHandler.class).error("handleRedirect: Failed to send redirect to " + redirect + ", aborting request without redirect", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private static String getValidatedRedirectTarget(HttpServletRequest request) {
        String redirect = request.getParameter("sling.auth.redirect");
        if (redirect == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(redirect) || redirect.length() == 0) {
            return request.getRequestURI();
        }
        if (!redirect.startsWith("/") && !redirect.contains("://")) {
            String path = request.getRequestURI();
            int lastSlash = (path = path.substring(request.getContextPath().length())).lastIndexOf(47);
            path = lastSlash > 0 ? path.substring(0, lastSlash + 1) : path;
            redirect = path.concat(redirect);
            redirect = ResourceUtil.normalize(redirect);
        }
        if (redirect.startsWith("/") && !redirect.startsWith(request.getContextPath())) {
            redirect = request.getContextPath().concat(redirect);
        }
        if (!AuthUtil.isRedirectValid(request, redirect)) {
            LoggerFactory.getLogger(DefaultAuthenticationFeedbackHandler.class).error("handleRedirect: Redirect target '{}' is invalid, redirecting to '/'", (Object)redirect);
            redirect = "/";
        }
        return redirect;
    }

    @Override
    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
    }

    @Override
    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        return DefaultAuthenticationFeedbackHandler.handleRedirect(request, response);
    }
}

