/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.spi.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.caconfig.spi.metadata.AbstractMetadata;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class PropertyMetadata<T>
extends AbstractMetadata<PropertyMetadata<T>> {
    private static final Class<?>[] SUPPORTED_TYPES_ARRAY = new Class[]{String.class, Integer.TYPE, Long.TYPE, Double.TYPE, Boolean.TYPE};
    public static final Set<Class<?>> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet(Arrays.asList(SUPPORTED_TYPES_ARRAY)));
    private final Class<T> type;
    private T defaultValue;
    private ConfigurationMetadata configurationMetadata;
    private int order;

    public PropertyMetadata(@Nonnull String name, @Nonnull Class<T> type) {
        super(name);
        Class<T> convertedType = PropertyMetadata.typeToPrimitive(type);
        if (!PropertyMetadata.isSupportedType(convertedType)) {
            throw new IllegalArgumentException("Invalid type for property '" + name + "': " + type);
        }
        this.type = convertedType;
    }

    public PropertyMetadata(@Nonnull String name, @Nonnull T defaultValue) {
        this(name, defaultValue.getClass());
        this.defaultValue = defaultValue;
    }

    private static Class<?> typeToPrimitive(Class<?> clazz) {
        if (clazz.isArray()) {
            if (ClassUtils.isPrimitiveWrapper(clazz.getComponentType())) {
                if (clazz == Integer[].class) {
                    return int[].class;
                }
                if (clazz == Long[].class) {
                    return long[].class;
                }
                if (clazz == Double[].class) {
                    return double[].class;
                }
                if (clazz == Boolean[].class) {
                    return boolean[].class;
                }
            }
        } else if (ClassUtils.isPrimitiveWrapper(clazz)) {
            if (clazz == Integer.class) {
                return Integer.TYPE;
            }
            if (clazz == Long.class) {
                return Long.TYPE;
            }
            if (clazz == Double.class) {
                return Double.TYPE;
            }
            if (clazz == Boolean.class) {
                return Boolean.TYPE;
            }
        }
        return clazz;
    }

    private static boolean isSupportedType(Class<?> paramType) {
        if (paramType.isArray()) {
            return PropertyMetadata.isSupportedType(paramType.getComponentType());
        }
        for (Class<?> type : SUPPORTED_TYPES) {
            if (!type.equals(paramType)) continue;
            return true;
        }
        return paramType == ConfigurationMetadata.class;
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public PropertyMetadata<T> defaultValue(T value) {
        this.defaultValue = value;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public PropertyMetadata<T> order(int value) {
        this.order = value;
        return this;
    }

    public ConfigurationMetadata getConfigurationMetadata() {
        return this.configurationMetadata;
    }

    public PropertyMetadata<T> configurationMetadata(ConfigurationMetadata configurationMetadata) {
        this.configurationMetadata = configurationMetadata;
        return this;
    }

    public boolean isNestedConfiguration() {
        return this.configurationMetadata != null && (this.type.equals(ConfigurationMetadata.class) || this.type.equals(ConfigurationMetadata[].class));
    }

    @Override
    public String toString() {
        return this.getName() + "[" + this.type.getSimpleName() + "]";
    }
}

