/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads;

import aQute.bnd.annotation.ProviderType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.sling.commons.threads.ThreadPoolConfig;

@ProviderType
public final class ModifiableThreadPoolConfig
implements ThreadPoolConfig {
    public static final String PROPERTY_MIN_POOL_SIZE = "minPoolSize";
    public static final String PROPERTY_MAX_POOL_SIZE = "maxPoolSize";
    public static final String PROPERTY_QUEUE_SIZE = "queueSize";
    public static final String PROPERTY_MAX_THREAD_AGE = "maxThreadAge";
    public static final String PROPERTY_KEEP_ALIVE_TIME = "keepAliveTime";
    public static final String PROPERTY_BLOCK_POLICY = "blockPolicy";
    public static final String PROPERTY_SHUTDOWN_GRACEFUL = "shutdownGraceful";
    public static final String PROPERTY_SHUTDOWN_WAIT_TIME = "shutdownWaitTime";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_DAEMON = "daemon";
    public static final String PROPERTY_NAME = "name";
    private int minPoolSize = 5;
    private int maxPoolSize = 5;
    private int queueSize = -1;
    private long maxThreadAge = TimeUnit.MINUTES.toMillis(5L);
    private long keepAliveTime = 60000L;
    private ThreadPoolConfig.ThreadPoolPolicy blockPolicy = ThreadPoolConfig.ThreadPoolPolicy.RUN;
    private boolean shutdownGraceful = true;
    private int shutdownWaitTimeMs = -1;
    private ThreadFactory factory;
    private ThreadPoolConfig.ThreadPriority priority = ThreadPoolConfig.ThreadPriority.NORM;
    private boolean isDaemon = false;

    public ModifiableThreadPoolConfig() {
    }

    public ModifiableThreadPoolConfig(ThreadPoolConfig copy) {
        if (copy != null) {
            this.minPoolSize = copy.getMinPoolSize();
            this.maxPoolSize = copy.getMaxPoolSize();
            this.queueSize = copy.getQueueSize();
            this.maxThreadAge = copy.getMaxThreadAge();
            this.keepAliveTime = copy.getKeepAliveTime();
            this.blockPolicy = copy.getBlockPolicy();
            this.shutdownGraceful = copy.isShutdownGraceful();
            this.shutdownWaitTimeMs = copy.getShutdownWaitTimeMs();
            this.factory = copy.getFactory();
            this.priority = copy.getPriority();
            this.isDaemon = copy.isDaemon();
        }
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @Override
    public long getMaxThreadAge() {
        return this.maxThreadAge;
    }

    public void setMaxThreadAge(long maxThreadAge) {
        this.maxThreadAge = maxThreadAge;
    }

    @Override
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    @Override
    public ThreadPoolConfig.ThreadPoolPolicy getBlockPolicy() {
        return this.blockPolicy;
    }

    public void setBlockPolicy(ThreadPoolConfig.ThreadPoolPolicy blockPolicy) {
        this.blockPolicy = blockPolicy;
        if (blockPolicy == null) {
            throw new IllegalArgumentException("Policy must not be null.");
        }
    }

    @Override
    public boolean isShutdownGraceful() {
        return this.shutdownGraceful;
    }

    public void setShutdownGraceful(boolean shutdownGraceful) {
        this.shutdownGraceful = shutdownGraceful;
    }

    @Override
    public int getShutdownWaitTimeMs() {
        return this.shutdownWaitTimeMs;
    }

    public void setShutdownWaitTimeMs(int shutdownWaitTimeMs) {
        this.shutdownWaitTimeMs = shutdownWaitTimeMs;
    }

    @Override
    public ThreadFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ThreadFactory factory) {
        this.factory = factory;
    }

    @Override
    public ThreadPoolConfig.ThreadPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ThreadPoolConfig.ThreadPriority priority) {
        if (priority == null) {
            throw new IllegalArgumentException("Priority must not be null.");
        }
        this.priority = priority;
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModifiableThreadPoolConfig) {
            ModifiableThreadPoolConfig o = (ModifiableThreadPoolConfig)obj;
            return this.minPoolSize == o.minPoolSize && this.maxPoolSize == o.maxPoolSize && this.queueSize == o.queueSize && this.maxThreadAge == o.maxThreadAge && this.keepAliveTime == o.keepAliveTime && this.blockPolicy.equals((Object)o.blockPolicy) && this.shutdownGraceful == o.shutdownGraceful && this.shutdownWaitTimeMs == o.shutdownWaitTimeMs && this.priority.equals((Object)o.priority) && this.isDaemon == o.isDaemon;
        }
        return false;
    }

    public int hashCode() {
        return this.blockPolicy.hashCode();
    }
}

