/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementFilter;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.TopologyConnectorClientInformation;
import org.apache.sling.discovery.base.connectors.ping.TopologyRequestValidator;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyConnectorClient
implements TopologyConnectorClientInformation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final URL connectorUrl;
    private final ClusterViewService clusterViewService;
    private final BaseConfig config;
    private final UUID id;
    private final AnnouncementRegistry announcementRegistry;
    private Announcement lastInheritedAnnouncement;
    private long lastPingedAt;
    private final String serverInfo;
    private int lastStatusCode = -1;
    private boolean autoStopped = false;
    private String statusDetails = null;
    private boolean suppressPingWarnings_ = false;
    private TopologyRequestValidator requestValidator;
    private String lastRequestEncoding;
    private String lastResponseEncoding;
    private long backoffPeriodEnd = -1L;

    TopologyConnectorClient(ClusterViewService clusterViewService, AnnouncementRegistry announcementRegistry, BaseConfig config, URL connectorUrl, String serverInfo) {
        if (clusterViewService == null) {
            throw new IllegalArgumentException("clusterViewService must not be null");
        }
        if (announcementRegistry == null) {
            throw new IllegalArgumentException("announcementRegistry must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (connectorUrl == null) {
            throw new IllegalArgumentException("connectorUrl must not be null");
        }
        this.requestValidator = new TopologyRequestValidator(config);
        this.clusterViewService = clusterViewService;
        this.announcementRegistry = announcementRegistry;
        this.config = config;
        this.connectorUrl = connectorUrl;
        this.serverInfo = serverInfo;
        this.id = UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ping(boolean force) {
        if (this.autoStopped) {
            this.logger.debug("ping: autoStopped=true, hence suppressing any further pings.");
            return;
        }
        if (force) {
            this.backoffPeriodEnd = -1L;
        } else if (this.backoffPeriodEnd > 0L) {
            if (System.currentTimeMillis() < this.backoffPeriodEnd) {
                this.logger.debug("ping: not issueing a heartbeat due to backoff instruction from peer.");
                return;
            }
            this.logger.debug("ping: backoff period ended, issuing another ping now.");
        }
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ping: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        HttpClientContext clientContext = HttpClientContext.create();
        CloseableHttpClient httpClient = this.createHttpClient();
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setConfig(RequestConfig.custom().setConnectTimeout(1000 * this.config.getSocketConnectTimeout()).build());
        Announcement resultingAnnouncement = null;
        try {
            LocalClusterView clusterView;
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                clientContext.getCredentialsProvider().setCredentials(new AuthScope(putRequest.getURI().getHost(), putRequest.getURI().getPort()), (Credentials)c);
            }
            Announcement topologyAnnouncement = new Announcement(this.clusterViewService.getSlingId());
            topologyAnnouncement.setServerInfo(this.serverInfo);
            try {
                clusterView = this.clusterViewService.getLocalClusterView();
            }
            catch (UndefinedClusterViewException e) {
                this.logger.warn("ping: no clusterView available at the moment, cannot ping others now: " + e);
                putRequest.releaseConnection();
                this.lastInheritedAnnouncement = resultingAnnouncement;
                this.lastPingedAt = System.currentTimeMillis();
                try {
                    httpClient.close();
                }
                catch (IOException e2) {
                    this.logger.error("disconnect: could not close httpClient: " + e2, (Throwable)e2);
                }
                return;
            }
            topologyAnnouncement.setLocalCluster(clusterView);
            if (force) {
                this.logger.debug("ping: sending a resetBackoff");
                topologyAnnouncement.setResetBackoff(true);
            }
            this.announcementRegistry.addAllExcept(topologyAnnouncement, clusterView, new AnnouncementFilter(){

                @Override
                public boolean accept(String receivingSlingId, Announcement announcement) {
                    for (InstanceDescription instance : clusterView.getInstances()) {
                        if (!instance.getSlingId().equals(receivingSlingId)) continue;
                        return true;
                    }
                    return false;
                }
            });
            String p = this.requestValidator.encodeMessage(topologyAnnouncement.asJSON());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: topologyAnnouncement json is: " + p);
            }
            this.requestValidator.trustMessage((HttpUriRequest)putRequest, p);
            if (this.config.isGzipConnectorRequestsEnabled()) {
                putRequest.addHeader("Content-Encoding", "gzip");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
                gzipOut.write(p.getBytes("UTF-8"));
                gzipOut.close();
                byte[] gzippedEncodedJson = baos.toByteArray();
                putRequest.setEntity((HttpEntity)new ByteArrayEntity(gzippedEncodedJson, ContentType.APPLICATION_JSON));
                this.lastRequestEncoding = "gzip";
            } else {
                StringEntity plaintext = new StringEntity(p, "UTF-8");
                plaintext.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                putRequest.setEntity((HttpEntity)plaintext);
                this.lastRequestEncoding = "plaintext";
            }
            putRequest.addHeader("Accept-Encoding", "gzip");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)putRequest, (HttpContext)clientContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: done. code=" + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            }
            this.lastStatusCode = response.getStatusLine().getStatusCode();
            this.lastResponseEncoding = null;
            if (response.getStatusLine().getStatusCode() == 200) {
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                this.lastResponseEncoding = contentEncoding != null && contentEncoding.getValue() != null && contentEncoding.getValue().contains("gzip") ? "gzip" : "plaintext";
                String responseBody = this.requestValidator.decodeMessage(putRequest.getURI().getPath(), (HttpResponse)response);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: response body=" + responseBody);
                }
                if (responseBody != null && responseBody.length() > 0) {
                    Announcement inheritedAnnouncement = Announcement.fromJSON(responseBody);
                    long backoffInterval = inheritedAnnouncement.getBackoffInterval();
                    if (backoffInterval > 0L) {
                        this.backoffPeriodEnd = System.currentTimeMillis() + 1000L * backoffInterval - 1000L;
                        this.logger.debug("ping: servlet instructed to backoff: backoffInterval=" + backoffInterval + ", resulting in period end of " + new Date(this.backoffPeriodEnd));
                    } else {
                        this.logger.debug("ping: servlet did not instruct any backoff-ing at this stage");
                        this.backoffPeriodEnd = -1L;
                    }
                    if (inheritedAnnouncement.isLoop()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("ping: connector response indicated a loop detected. not registering this announcement from " + inheritedAnnouncement.getOwnerId());
                        }
                        if (inheritedAnnouncement.getOwnerId().equals(this.clusterViewService.getSlingId()) && this.config.isAutoStopLocalLoopEnabled()) {
                            inheritedAnnouncement = null;
                            this.autoStopped = true;
                        }
                    } else {
                        inheritedAnnouncement.setInherited(true);
                        if (this.announcementRegistry.registerAnnouncement(inheritedAnnouncement) == -1L) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("ping: connector response is from an instance which I already see in my topology" + inheritedAnnouncement);
                            }
                            this.statusDetails = "receiving side is seeing me via another path (connector or cluster) already (loop)";
                            return;
                        }
                    }
                    resultingAnnouncement = inheritedAnnouncement;
                    this.statusDetails = null;
                } else {
                    this.statusDetails = "no response body received";
                }
            } else {
                this.statusDetails = "got HTTP Status-Code: " + this.lastStatusCode;
            }
            this.suppressPingWarnings_ = false;
        }
        catch (IOException e) {
            if (this.suppressPingWarnings_) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: got IOException: " + e + ", uri=" + uri);
                }
            } else {
                this.suppressPingWarnings_ = true;
                this.logger.warn("ping: got IOException [suppressing further warns]: " + e + ", uri=" + uri);
            }
            this.statusDetails = e.toString();
        }
        catch (JSONException e) {
            this.logger.warn("ping: got JSONException: " + e);
            this.statusDetails = e.toString();
        }
        catch (RuntimeException re) {
            this.logger.warn("ping: got RuntimeException: " + re, (Throwable)re);
            this.statusDetails = re.toString();
        }
        finally {
            putRequest.releaseConnection();
            this.lastInheritedAnnouncement = resultingAnnouncement;
            this.lastPingedAt = System.currentTimeMillis();
            try {
                httpClient.close();
            }
            catch (IOException e) {
                this.logger.error("disconnect: could not close httpClient: " + e, (Throwable)e);
            }
        }
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(1000 * this.config.getSoTimeout()).build());
        builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        return builder.build();
    }

    @Override
    public int getStatusCode() {
        return this.lastStatusCode;
    }

    @Override
    public URL getConnectorUrl() {
        return this.connectorUrl;
    }

    @Override
    public boolean representsLoop() {
        if (this.autoStopped) {
            return true;
        }
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return this.lastInheritedAnnouncement.isLoop();
    }

    @Override
    public boolean isConnected() {
        if (this.autoStopped) {
            return false;
        }
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return this.announcementRegistry.hasActiveAnnouncement(this.lastInheritedAnnouncement.getOwnerId());
    }

    @Override
    public String getStatusDetails() {
        if (this.autoStopped) {
            return "auto-stopped";
        }
        if (this.lastInheritedAnnouncement == null) {
            return this.statusDetails;
        }
        if (this.announcementRegistry.hasActiveAnnouncement(this.lastInheritedAnnouncement.getOwnerId())) {
            return null;
        }
        return "received announcement has expired (it was last renewed " + new Date(this.lastPingedAt) + ") - consider increasing heartbeat timeout";
    }

    @Override
    public long getLastPingSent() {
        return this.lastPingedAt;
    }

    @Override
    public int getNextPingDue() {
        long absDue = this.backoffPeriodEnd > 0L ? this.backoffPeriodEnd : this.lastPingedAt + 1000L * this.config.getConnectorPingInterval();
        int relDue = (int)((absDue - System.currentTimeMillis()) / 1000L);
        if (relDue < 0) {
            return -1;
        }
        return relDue;
    }

    @Override
    public boolean isAutoStopped() {
        return this.autoStopped;
    }

    @Override
    public String getLastRequestEncoding() {
        return this.lastRequestEncoding == null ? "" : this.lastRequestEncoding;
    }

    @Override
    public String getLastResponseEncoding() {
        return this.lastResponseEncoding == null ? "" : this.lastResponseEncoding;
    }

    @Override
    public String getRemoteSlingId() {
        if (this.lastInheritedAnnouncement == null) {
            return null;
        }
        return this.lastInheritedAnnouncement.getOwnerId();
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("disconnect: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        if (this.lastInheritedAnnouncement != null) {
            this.announcementRegistry.unregisterAnnouncement(this.lastInheritedAnnouncement.getOwnerId());
        }
        HttpClientContext clientContext = HttpClientContext.create();
        CloseableHttpClient httpClient = this.createHttpClient();
        HttpDelete deleteRequest = new HttpDelete(uri);
        deleteRequest.setConfig(RequestConfig.custom().setConnectTimeout(1000 * this.config.getSocketConnectTimeout()).build());
        try {
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                clientContext.getCredentialsProvider().setCredentials(new AuthScope(deleteRequest.getURI().getHost(), deleteRequest.getURI().getPort()), (Credentials)c);
            }
            this.requestValidator.trustMessage((HttpUriRequest)deleteRequest, null);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)deleteRequest, (HttpContext)clientContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("disconnect: done. code=" + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (IOException e) {
            this.logger.warn("disconnect: got IOException: " + e);
        }
        catch (RuntimeException re) {
            this.logger.error("disconnect: got RuntimeException: " + re, (Throwable)re);
        }
        finally {
            deleteRequest.releaseConnection();
            try {
                httpClient.close();
            }
            catch (IOException e) {
                this.logger.error("disconnect: could not close httpClient: " + e, (Throwable)e);
            }
        }
    }
}

