/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons;

import java.sql.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDelayingTopologyEventListener
implements TopologyEventListener {
    private final Logger logger;
    private final TopologyEventListener delegate;
    private final Object syncObj = new Object();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private boolean delaying = true;
    private TopologyEvent pendingDelayedEvent = null;

    public InitDelayingTopologyEventListener(long startupDelay, TopologyEventListener delegate, Scheduler scheduler) {
        this(startupDelay, delegate, scheduler, null);
    }

    public InitDelayingTopologyEventListener(long startupDelay, TopologyEventListener delegate, Scheduler scheduler, Logger loggerOrNull) {
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler must not be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        if (startupDelay <= 0L) {
            throw new IllegalArgumentException("startupDelay must be greater than 0, not " + startupDelay);
        }
        this.delegate = delegate;
        this.logger = loggerOrNull != null ? loggerOrNull : LoggerFactory.getLogger(this.getClass());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (InitDelayingTopologyEventListener.this.active.get()) {
                    InitDelayingTopologyEventListener.this.afterStartupDelay();
                }
            }
        };
        this.active.set(true);
        if (!scheduler.schedule(r, scheduler.AT(new Date(System.currentTimeMillis() + startupDelay * 1000L)))) {
            this.logger.warn("activate: could not schedule startupDelay handler with scheduler ({}) - thus starting ({}) immediately", (Object)scheduler, (Object)delegate);
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTopologyEvent(TopologyEvent event) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.delaying) {
                this.logger.debug("handleTopologyEvent: delaying processing of received topology event (startup delay active) {}", (Object)event);
                this.pendingDelayedEvent = event;
                return;
            }
            if (this.pendingDelayedEvent != null) {
                if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
                    this.pendingDelayedEvent = event;
                    this.logger.info("handleTopologyEvent: ignoring received topology event of type CHANGING {}", (Object)event);
                    return;
                }
                this.pendingDelayedEvent = null;
                this.logger.debug("handleTopologyEvent: first stable topology event received after startup delaying. Simulating an INIT event with this new view: {}", (Object)event);
                event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, event.getNewView());
            } else {
                this.logger.debug("handleTopologyEvent: received topology event {}", (Object)event);
            }
        }
        this.delegate.handleTopologyEvent(event);
    }

    public void dispose() {
        this.active.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterStartupDelay() {
        Object object = this.syncObj;
        synchronized (object) {
            this.delaying = false;
            if (this.pendingDelayedEvent == null) {
                this.logger.debug("afterStartupDelay: startup delay passed without any events delayed. So, ready for first upcoming INIT event");
            } else if (this.pendingDelayedEvent.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
                this.logger.debug("afterStartupDelay: startup delay passed, pending delayed event was CHANGING. Waiting for next stable topology event");
            } else {
                TopologyEvent artificialInitEvent = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, this.pendingDelayedEvent.getNewView());
                this.logger.debug("afterStartupDelay: startup delay passed, last pending delayed event was stable ({}). Simulating an INIT event with that view: {}", (Object)this.pendingDelayedEvent, (Object)artificialInitEvent);
                this.pendingDelayedEvent = null;
                this.delegate.handleTopologyEvent(artificialInitEvent);
            }
        }
    }
}

