/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.sightly;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.hapi.HApiProperty;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeView
implements Use {
    private static final Logger LOG = LoggerFactory.getLogger(TypeView.class);
    private HApiUtil hapi;
    private HApiType me;
    private HApiType parent;
    private String description;
    private SlingHttpServletRequest request;
    private SlingScriptHelper sling;
    private Resource resource;
    private ResourceResolver resourceResolver;

    @Override
    public void init(Bindings bindings) {
        this.request = (SlingHttpServletRequest)bindings.get("request");
        this.sling = (SlingScriptHelper)bindings.get("sling");
        this.resource = (Resource)bindings.get("resource");
        this.resourceResolver = this.request.getResourceResolver();
        try {
            this.activate();
        }
        catch (Exception e) {
            LOG.error("Failed to activate Use class", (Throwable)e);
        }
    }

    public void activate() throws Exception {
        this.hapi = this.sling.getService(HApiUtil.class);
        this.me = this.hapi.fromPath(this.resourceResolver, this.resource.getPath());
        LOG.debug("me: {}  resource: {}", (Object)this.me, (Object)this.resource.getPath());
        this.description = this.me.getDescription();
        this.parent = this.me.getParent();
    }

    public String getTitle() {
        return this.me.getFqdn();
    }

    public String getDescription() {
        return this.description;
    }

    public String getParentUrl() {
        if (null != this.parent) {
            return this.parent.getUrl();
        }
        return null;
    }

    public String getParentFqdn() {
        if (null != this.parent) {
            return this.parent.getFqdn();
        }
        return null;
    }

    public List<String> getParameters() {
        return this.me.getParameters();
    }

    public List<HApiProperty> getProps() {
        ArrayList<HApiProperty> props = new ArrayList<HApiProperty>(this.me.getAllProperties().values());
        LOG.debug("props: ", props);
        return props;
    }

    public boolean getHasProps() {
        return this.getProps().size() > 0;
    }
}

