/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.JcrPropertyMapCacheEntry;
import org.slf4j.LoggerFactory;

@Deprecated
public final class JcrModifiablePropertyMap
extends JcrPropertyMap
implements PersistableValueMap {
    private static volatile boolean LOG_DEPRECATED = true;
    private Set<String> changedProperties;

    public JcrModifiablePropertyMap(Node node) {
        super(node);
        if (LOG_DEPRECATED) {
            LOG_DEPRECATED = false;
            LoggerFactory.getLogger(this.getClass()).warn("DEPRECATION WARNING: JcrModifiablePropertyMap is deprecated. Please switch to resource API.");
        }
    }

    public JcrModifiablePropertyMap(Node node, ClassLoader dynamicCL) {
        super(node, dynamicCL);
        if (LOG_DEPRECATED) {
            LOG_DEPRECATED = false;
            LoggerFactory.getLogger(this.getClass()).warn("DEPRECATION WARNING: JcrModifiablePropertyMap is deprecated. Please switch to resource API.");
        }
    }

    @Override
    public void clear() {
        this.readFully();
        if (this.changedProperties == null) {
            this.changedProperties = new HashSet<String>();
        }
        this.changedProperties.addAll(this.cache.keySet());
        this.cache.clear();
        this.valueCache.clear();
    }

    @Override
    public Object put(String aKey, Object value) {
        String key = this.checkKey(aKey);
        if (key.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new NullPointerException("Value should not be null (key = " + key + ")");
        }
        this.readFully();
        Object oldValue = this.get(key);
        try {
            this.cache.put(key, new JcrPropertyMapCacheEntry(value, this.getNode()));
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException("Value for key " + key + " can't be put into node: " + value, re);
        }
        this.valueCache.put(key, value);
        if (this.changedProperties == null) {
            this.changedProperties = new HashSet<String>();
        }
        this.changedProperties.add(key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.readFully();
        if (t != null) {
            for (Map.Entry<? extends String, ? extends Object> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object remove(Object aKey) {
        String key = this.checkKey(aKey.toString());
        this.readFully();
        Object oldValue = this.cache.remove(key);
        this.valueCache.remove(key);
        if (this.changedProperties == null) {
            this.changedProperties = new HashSet<String>();
        }
        this.changedProperties.add(key);
        return oldValue;
    }

    @Override
    public void reset() {
        if (this.changedProperties != null) {
            this.changedProperties = null;
        }
        this.cache.clear();
        this.valueCache.clear();
        this.fullyRead = false;
    }

    @Override
    public void save() throws PersistenceException {
        if (this.changedProperties == null || this.changedProperties.size() == 0) {
            return;
        }
        try {
            Node node = this.getNode();
            if (this.changedProperties.contains("jcr:mixinTypes")) {
                if (this.cache.containsKey("jcr:mixinTypes")) {
                    JcrPropertyMapCacheEntry entry = (JcrPropertyMapCacheEntry)this.cache.get("jcr:mixinTypes");
                    NodeUtil.handleMixinTypes((Node)node, (String[])((String[])entry.convertToType(String[].class, node, this.getDynamicClassLoader())));
                } else {
                    NodeUtil.handleMixinTypes((Node)node, null);
                }
            }
            for (String key : this.changedProperties) {
                String name = this.escapeKeyName(key);
                if ("jcr:mixinTypes".equals(name)) continue;
                if (this.cache.containsKey(key)) {
                    JcrPropertyMapCacheEntry entry = (JcrPropertyMapCacheEntry)this.cache.get(key);
                    if (entry.isArray()) {
                        node.setProperty(name, (Value[])entry.convertToType(Value[].class, node, this.getDynamicClassLoader()));
                        continue;
                    }
                    node.setProperty(name, (Value)entry.convertToType(Value.class, node, this.getDynamicClassLoader()));
                    continue;
                }
                if (!node.hasProperty(name)) continue;
                node.getProperty(name).remove();
            }
            node.getSession().save();
            this.reset();
        }
        catch (RepositoryException re) {
            throw new PersistenceException("Unable to persist changes.", (Throwable)re, this.getPath(), null);
        }
    }
}

