/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.resource.internal.helper.LazyInputStream;
import org.slf4j.LoggerFactory;

@Deprecated
public class JcrResourceUtil {
    private static volatile boolean LOG_DEPRECATED_QUERY = true;
    private static volatile boolean LOG_DEPRECATED_TO_JAVA_OBJECT_1 = true;
    private static volatile boolean LOG_DEPRECATED_TO_JAVA_OBJECT_2 = true;
    private static volatile boolean LOG_DEPRECATED_CREATE_VALUE = true;
    private static volatile boolean LOG_DEPRECATED_SET_PROPERTY = true;
    private static volatile boolean LOG_DEPRECATED_CREATE_PATH_1 = true;
    private static volatile boolean LOG_DEPRECATED_CREATE_PATH_2 = true;
    private static volatile boolean LOG_DEPRECATED_GET_RST_1 = true;
    private static volatile boolean LOG_DEPRECATED_GET_RST_2 = true;
    private static volatile boolean LOG_DEPRECATED_RT_TO_PATH = true;

    public static QueryResult query(Session session, String query, String language) throws RepositoryException {
        if (LOG_DEPRECATED_QUERY) {
            LOG_DEPRECATED_QUERY = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.query is deprecated. Please use the resource resolver.");
        }
        QueryManager qManager = session.getWorkspace().getQueryManager();
        Query q = qManager.createQuery(query, language);
        return q.execute();
    }

    public static Object toJavaObject(Value value) throws RepositoryException {
        if (LOG_DEPRECATED_TO_JAVA_OBJECT_1) {
            LOG_DEPRECATED_TO_JAVA_OBJECT_1 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.toJavaObject(Value) is deprecated. Please use the resource resolver API.");
        }
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    public static Object toJavaObject(Property property) throws RepositoryException {
        if (LOG_DEPRECATED_TO_JAVA_OBJECT_2) {
            LOG_DEPRECATED_TO_JAVA_OBJECT_2 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.toJavaObject(Property) is deprecated. Please use the resource resolver API.");
        }
        if (property.isMultiple()) {
            Object firstValue;
            Value[] values = property.getValues();
            Object object = firstValue = values.length > 0 ? JcrResourceUtil.toJavaObject(values[0]) : null;
            Object[] result = firstValue instanceof Boolean ? new Boolean[values.length] : (firstValue instanceof Calendar ? new Calendar[values.length] : (firstValue instanceof Double ? new Double[values.length] : (firstValue instanceof Long ? new Long[values.length] : (firstValue instanceof BigDecimal ? new BigDecimal[values.length] : (firstValue instanceof InputStream ? new Object[values.length] : new String[values.length])))));
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value == null) continue;
                result[i] = JcrResourceUtil.toJavaObject(value);
            }
            return result;
        }
        return JcrResourceUtil.toJavaObject(property.getValue());
    }

    public static Value createValue(Object value, Session session) throws RepositoryException {
        if (LOG_DEPRECATED_CREATE_VALUE) {
            LOG_DEPRECATED_CREATE_VALUE = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.createValue is deprecated. Please use the resource resolver API.");
        }
        ValueFactory fac = session.getValueFactory();
        Object val = value instanceof Calendar ? fac.createValue((Calendar)value) : (value instanceof InputStream ? fac.createValue(fac.createBinary((InputStream)value)) : (value instanceof Node ? fac.createValue((Node)value) : (value instanceof BigDecimal ? fac.createValue((BigDecimal)value) : (value instanceof Long ? fac.createValue(((Long)value).longValue()) : (value instanceof Short ? fac.createValue((long)((Short)value).shortValue()) : (value instanceof Integer ? fac.createValue((long)((Integer)value).intValue()) : (value instanceof Number ? fac.createValue(((Number)value).doubleValue()) : (value instanceof Boolean ? fac.createValue(((Boolean)value).booleanValue()) : (value instanceof String ? fac.createValue((String)value) : null)))))))));
        return val;
    }

    public static void setProperty(Node node, String propertyName, Object propertyValue) throws RepositoryException {
        if (LOG_DEPRECATED_SET_PROPERTY) {
            LOG_DEPRECATED_SET_PROPERTY = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.setProperty is deprecated. Please use the resource resolver API.");
        }
        if (propertyValue == null) {
            node.setProperty(propertyName, (String)null);
        } else if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            Value[] setValues = new Value[length];
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(propertyValue, i);
                setValues[i] = JcrResourceUtil.createValue(value, node.getSession());
            }
            node.setProperty(propertyName, setValues);
        } else {
            node.setProperty(propertyName, JcrResourceUtil.createValue(propertyValue, node.getSession()));
        }
    }

    @Deprecated
    public static String resourceTypeToPath(String type) {
        if (LOG_DEPRECATED_RT_TO_PATH) {
            LOG_DEPRECATED_RT_TO_PATH = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.resourceTypeToPath is deprecated. Please use the resource resolver API.");
        }
        return type.replaceAll("\\:", "/");
    }

    @Deprecated
    public static String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        if (LOG_DEPRECATED_GET_RST_1) {
            LOG_DEPRECATED_GET_RST_1 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.getResourceSuperType(String) is deprecated. Please use the resource resolver API.");
        }
        return ResourceUtil.getResourceSuperType(resourceResolver, resourceType);
    }

    @Deprecated
    public static String getResourceSuperType(Resource resource) {
        String resourceSuperType;
        if (LOG_DEPRECATED_GET_RST_2) {
            LOG_DEPRECATED_GET_RST_2 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.getResourceSuperType(Resource) is deprecated. Please use the resource resolver API.");
        }
        if ((resourceSuperType = resource.getResourceSuperType()) == null) {
            ResourceResolver resolver = resource.getResourceResolver();
            String resourceType = resource.getResourceType();
            resourceSuperType = ResourceUtil.getResourceSuperType(resolver, resourceType);
        }
        return resourceSuperType;
    }

    public static Node createPath(String path, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        if (LOG_DEPRECATED_CREATE_PATH_1) {
            LOG_DEPRECATED_CREATE_PATH_1 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.createPath(String, ...) is deprecated. Please use the resource resolver API.");
        }
        if (path == null || path.length() == 0 || "/".equals(path)) {
            return session.getRootNode();
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!session.itemExists(path)) {
            String existingPath = JcrResourceUtil.findExistingPath(path, session);
            String relativePath = null;
            Node parentNode = null;
            if (existingPath != null) {
                parentNode = session.getNode(existingPath);
                relativePath = path.substring(existingPath.length() + 1);
            } else {
                relativePath = path.substring(1);
                parentNode = session.getRootNode();
            }
            return JcrResourceUtil.createPath(parentNode, relativePath, intermediateNodeType, nodeType, autoSave);
        }
        return session.getNode(path);
    }

    public static Node createPath(Node parentNode, String relativePath, String intermediateNodeType, String nodeType, boolean autoSave) throws RepositoryException {
        if (LOG_DEPRECATED_CREATE_PATH_2) {
            LOG_DEPRECATED_CREATE_PATH_2 = false;
            LoggerFactory.getLogger(JcrResourceUtil.class).warn("DEPRECATION WARNING: JcrResourceUtil.createPath(Node,...) is deprecated. Please use the resource resolver API.");
        }
        if (relativePath == null || relativePath.length() == 0 || "/".equals(relativePath)) {
            return parentNode;
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if (!parentNode.hasNode(relativePath)) {
            Session session = parentNode.getSession();
            String path = parentNode.getPath() + "/" + relativePath;
            String existingPath = JcrResourceUtil.findExistingPath(path, session);
            if (existingPath != null) {
                parentNode = session.getNode(existingPath);
                relativePath = path.substring(existingPath.length() + 1);
            }
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            if (intermediateNodeType != null) {
                                node.addNode(token, intermediateNodeType);
                            } else {
                                node.addNode(token);
                            }
                            if (autoSave) {
                                session.save();
                            }
                        }
                        catch (RepositoryException re) {
                            session.refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                if (nodeType != null) {
                    node.addNode(relativePath, nodeType);
                } else {
                    node.addNode(relativePath);
                }
                if (autoSave) {
                    session.save();
                }
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }

    private static String findExistingPath(String path, Session session) throws RepositoryException {
        int currentIndex = path.lastIndexOf(47);
        String temp = path;
        String existingPath = null;
        while (currentIndex > 0) {
            if (session.itemExists(temp = temp.substring(0, currentIndex))) {
                existingPath = temp;
                break;
            }
            currentIndex = temp.lastIndexOf("/");
        }
        return existingPath;
    }
}

