/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Commentable;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelResolveUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Version;

public abstract class MergeUtility {
    public static void merge(Model base, Model additional) {
        MergeUtility.merge(base, additional, new MergeOptions());
    }

    public static void merge(Model base, Model additional, MergeOptions options) {
        for (Feature feature : additional.getFeatures()) {
            Feature baseFeature = base.getOrCreateFeature(feature.getName());
            boolean overwrite = false;
            if (baseFeature.getVersion() != null) {
                Version addVersion;
                Version baseVersion;
                if (feature.getVersion() == null || (baseVersion = new Version(baseFeature.getVersion())).compareTo(addVersion = new Version(feature.getVersion())) >= 0) continue;
                overwrite = true;
            } else if (feature.getVersion() != null) {
                overwrite = true;
            }
            if (overwrite) {
                baseFeature.setVersion(feature.getVersion());
                baseFeature.getRunModes().clear();
                baseFeature.getAdditionalSections().clear();
                baseFeature.getVariables().clear();
                baseFeature.setComment(null);
            }
            MergeUtility.mergeComments(baseFeature, feature);
            baseFeature.setType(feature.getType());
            baseFeature.getAdditionalSections().addAll(feature.getAdditionalSections());
            baseFeature.getVariables().putAll(feature.getVariables());
            MergeUtility.mergeComments(baseFeature.getVariables(), feature.getVariables());
            for (RunMode runMode : feature.getRunModes()) {
                String[] names = runMode.getNames();
                if (options.isHandleRemoveRunMode() && names != null && MergeUtility.handleRemoveRunMode(baseFeature, runMode)) continue;
                RunMode baseRunMode = baseFeature.getOrCreateRunMode(names);
                for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                    ArtifactGroup baseGroup = baseRunMode.getOrCreateArtifactGroup(artifactGroup.getStartLevel());
                    MergeUtility.mergeComments(baseGroup, artifactGroup);
                    int foundStartLevel = 0;
                    for (Artifact artifact : artifactGroup) {
                        boolean addArtifact = true;
                        for (ArtifactGroup searchGroup : baseRunMode.getArtifactGroups()) {
                            Artifact found = searchGroup.search(artifact);
                            if (found == null) continue;
                            if (options.isLatestArtifactWins()) {
                                searchGroup.remove(found);
                                foundStartLevel = searchGroup.getStartLevel();
                                continue;
                            }
                            try {
                                Version baseVersion = new Version(found.getVersion());
                                Version mergeVersion = new Version(artifact.getVersion());
                                if (baseVersion.compareTo(mergeVersion) <= 0) {
                                    searchGroup.remove(found);
                                    foundStartLevel = searchGroup.getStartLevel();
                                    continue;
                                }
                                addArtifact = false;
                            }
                            catch (IllegalArgumentException iae) {
                                if (found.getVersion().compareTo(artifact.getVersion()) <= 0) {
                                    searchGroup.remove(found);
                                    foundStartLevel = searchGroup.getStartLevel();
                                    continue;
                                }
                                addArtifact = false;
                            }
                        }
                        if (!addArtifact) continue;
                        if (artifactGroup.getStartLevel() == 0 && foundStartLevel != 0) {
                            baseRunMode.getOrCreateArtifactGroup(foundStartLevel).add(artifact);
                            continue;
                        }
                        baseGroup.add(artifact);
                    }
                }
                for (Configuration configuration : runMode.getConfigurations()) {
                    Configuration found = baseRunMode.getOrCreateConfiguration(configuration.getPid(), configuration.getFactoryPid());
                    MergeUtility.mergeConfiguration(found, configuration);
                    MergeUtility.mergeComments(found, configuration);
                }
                for (Map.Entry entry : runMode.getSettings()) {
                    baseRunMode.getSettings().put((String)entry.getKey(), (String)entry.getValue());
                }
                MergeUtility.mergeComments(baseRunMode.getSettings(), runMode.getSettings());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean handleRemoveRunMode(Feature baseFeature, RunMode runMode) {
        String[] names = runMode.getNames();
        int removeIndex = -1;
        int index = 0;
        for (String string : names) {
            if (string.equals(":remove")) {
                removeIndex = index;
                break;
            }
            ++index;
        }
        if (removeIndex != -1) {
            RunMode baseRunMode;
            String[] newNames = null;
            if (names.length > 1) {
                void var8_13;
                newNames = new String[names.length - 1];
                index = 0;
                String[] arr$ = names;
                int len$ = arr$.length;
                boolean bl = false;
                while (var8_13 < len$) {
                    String name = arr$[var8_13];
                    if (!name.equals(":remove")) {
                        newNames[index++] = name;
                    }
                    ++var8_13;
                }
            }
            if ((baseRunMode = baseFeature.getRunMode(names = newNames)) != null) {
                for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                    for (Artifact artifact : artifactGroup) {
                        for (ArtifactGroup searchGroup : baseRunMode.getArtifactGroups()) {
                            Artifact found = searchGroup.search(artifact);
                            if (found == null) continue;
                            searchGroup.remove(found);
                        }
                    }
                }
                for (Configuration configuration : runMode.getConfigurations()) {
                    Configuration found = baseRunMode.getConfiguration(configuration.getPid(), configuration.getFactoryPid());
                    if (found == null) continue;
                    baseRunMode.getConfigurations().remove(found);
                }
                for (Map.Entry entry : runMode.getSettings()) {
                    baseRunMode.getSettings().remove((String)entry.getKey());
                }
            }
            return true;
        }
        return false;
    }

    private static void mergeConfiguration(Configuration baseConfig, Configuration mergeConfig) {
        boolean isNew = baseConfig.getProperties().isEmpty();
        if (isNew) {
            MergeUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            Object mode = mergeConfig.getProperties().get(":rawconfig.mode");
            if (mode != null) {
                baseConfig.getProperties().put(":rawconfig.mode", mode);
            }
        } else {
            boolean mergeIsRaw;
            boolean baseIsRaw = baseConfig.getProperties().get(":rawconfig") != null;
            boolean bl = mergeIsRaw = mergeConfig.getProperties().get(":rawconfig") != null;
            if (baseIsRaw && mergeIsRaw) {
                String cfgMode = (String)mergeConfig.getProperties().get(":rawconfig.mode");
                if (cfgMode == null || "overwrite".equals(cfgMode)) {
                    MergeUtility.copyConfigurationProperties(baseConfig, mergeConfig);
                } else {
                    Configuration newConfig = new Configuration(baseConfig.getPid(), baseConfig.getFactoryPid());
                    ModelResolveUtility.getProcessedConfiguration(null, newConfig, baseConfig, false, null);
                    MergeUtility.clearConfiguration(baseConfig);
                    MergeUtility.copyConfigurationProperties(baseConfig, newConfig);
                    MergeUtility.clearConfiguration(newConfig);
                    ModelResolveUtility.getProcessedConfiguration(null, newConfig, mergeConfig, false, null);
                    if (baseConfig.isSpecial()) {
                        String baseValue = baseConfig.getProperties().get(baseConfig.getPid()).toString();
                        String mergeValue = newConfig.getProperties().get(baseConfig.getPid()).toString();
                        baseConfig.getProperties().put(baseConfig.getPid(), baseValue + "\n" + mergeValue);
                    } else {
                        MergeUtility.copyConfigurationProperties(baseConfig, newConfig);
                    }
                }
            } else if (!baseIsRaw && !mergeIsRaw) {
                MergeUtility.clearConfiguration(baseConfig);
                MergeUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            } else if (!baseIsRaw && mergeIsRaw) {
                String cfgMode = (String)mergeConfig.getProperties().get(":rawconfig.mode");
                if (cfgMode == null || "overwrite".equals(cfgMode)) {
                    MergeUtility.clearConfiguration(baseConfig);
                    MergeUtility.copyConfigurationProperties(baseConfig, mergeConfig);
                } else {
                    Configuration newMergeConfig = new Configuration(mergeConfig.getPid(), mergeConfig.getFactoryPid());
                    ModelResolveUtility.getProcessedConfiguration(null, newMergeConfig, mergeConfig, false, null);
                    if (baseConfig.isSpecial()) {
                        String baseValue = baseConfig.getProperties().get(baseConfig.getPid()).toString();
                        String mergeValue = newMergeConfig.getProperties().get(baseConfig.getPid()).toString();
                        baseConfig.getProperties().put(baseConfig.getPid(), baseValue + "\n" + mergeValue);
                    } else {
                        MergeUtility.copyConfigurationProperties(baseConfig, newMergeConfig);
                    }
                }
            } else {
                MergeUtility.clearConfiguration(baseConfig);
                MergeUtility.copyConfigurationProperties(baseConfig, mergeConfig);
            }
        }
    }

    private static void clearConfiguration(Configuration cfg) {
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> e = cfg.getProperties().keys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        for (String key : keys) {
            cfg.getProperties().remove(key);
        }
    }

    private static void copyConfigurationProperties(Configuration baseConfig, Configuration mergeConfig) {
        Enumeration<String> e = mergeConfig.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(":rawconfig.mode")) continue;
            baseConfig.getProperties().put(key, mergeConfig.getProperties().get(key));
        }
    }

    public static void mergeComments(Commentable base, Commentable additional) {
        if (base.getComment() == null) {
            base.setComment(additional.getComment());
        } else if (additional.getComment() != null) {
            base.setComment(base.getComment() + "\n" + additional.getComment());
        }
    }

    public static class MergeOptions {
        private boolean handleRemoveRunMode = true;
        private boolean latestArtifactWins = true;

        public boolean isHandleRemoveRunMode() {
            return this.handleRemoveRunMode;
        }

        public MergeOptions setHandleRemoveRunMode(boolean handleRemoveRunMode) {
            this.handleRemoveRunMode = handleRemoveRunMode;
            return this;
        }

        public boolean isLatestArtifactWins() {
            return this.latestArtifactWins;
        }

        public MergeOptions setLatestArtifactWins(boolean latestArtifactWins) {
            this.latestArtifactWins = latestArtifactWins;
            return this;
        }
    }
}

