/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.EffectiveModelProcessor;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.MergeUtility;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelProcessor;
import org.apache.sling.provisioning.model.ModelResolveUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Traceable;
import org.apache.sling.provisioning.model.Version;

public abstract class ModelUtility {
    @Deprecated
    public static void merge(Model base, Model additional) {
        MergeUtility.merge(base, additional);
    }

    @Deprecated
    public static void merge(Model base, Model additional, boolean handleRemove) {
        MergeUtility.MergeOptions opts = new MergeUtility.MergeOptions();
        opts.setHandleRemoveRunMode(handleRemove);
        MergeUtility.merge(base, additional, opts);
    }

    @Deprecated
    public static Model getEffectiveModel(Model model, VariableResolver resolver) {
        return ModelUtility.getEffectiveModel(model, new ResolverOptions().variableResolver(resolver));
    }

    public static Model getEffectiveModel(Model model) {
        return ModelUtility.getEffectiveModel(model, new ResolverOptions());
    }

    public static Model getEffectiveModel(Model model, ResolverOptions options) {
        EffectiveModelProcessor processor = new EffectiveModelProcessor(options);
        return processor.process(model);
    }

    public static Map<Traceable, String> validate(Model model) {
        HashMap<Traceable, String> errors = new HashMap<Traceable, String>();
        for (Feature feature : model.getFeatures()) {
            if (feature.getName() == null || feature.getName().isEmpty()) {
                ModelUtility.addError(errors, feature, "Name is required for a feature.");
            }
            if (feature.getVersion() != null) {
                try {
                    new Version(feature.getVersion());
                }
                catch (IllegalArgumentException iae) {
                    ModelUtility.addError(errors, feature, "Version is not a valid version: " + feature.getVersion());
                }
            }
            for (RunMode runMode : feature.getRunModes()) {
                Object[] rm = runMode.getNames();
                if (rm != null) {
                    int hasSpecial = 0;
                    boolean hasRemove = false;
                    for (String string : rm) {
                        if (!string.startsWith(":")) continue;
                        if (hasSpecial > 0) {
                            if (hasSpecial == 1) {
                                if (":remove".equals(string) && !hasRemove) {
                                    hasRemove = true;
                                    hasSpecial = 2;
                                    continue;
                                }
                                if (hasRemove && !":remove".equals(string)) {
                                    hasSpecial = 2;
                                    continue;
                                }
                                hasSpecial = 2;
                                ModelUtility.addError(errors, runMode, "Invalid modes " + Arrays.toString(rm));
                                break;
                            }
                            ++hasSpecial;
                            ModelUtility.addError(errors, runMode, "Invalid modes " + Arrays.toString(rm));
                            break;
                        }
                        hasSpecial = 1;
                        hasRemove = ":remove".equals(string);
                    }
                }
                for (ArtifactGroup sl : runMode.getArtifactGroups()) {
                    if (sl.getStartLevel() < 0) {
                        ModelUtility.addError(errors, sl, "Invalid start level " + sl.getStartLevel());
                    }
                    for (Artifact a : sl) {
                        String error = null;
                        if (a.getGroupId() == null || a.getGroupId().isEmpty()) {
                            error = "groupId missing";
                        }
                        if (a.getArtifactId() == null || a.getArtifactId().isEmpty()) {
                            error = (error != null ? error + ", " : "") + "artifactId missing";
                        }
                        if (a.getVersion() == null || a.getVersion().isEmpty()) {
                            error = (error != null ? error + ", " : "") + "version missing";
                        }
                        if (a.getType() == null || a.getType().isEmpty()) {
                            error = (error != null ? error + ", " : "") + "type missing";
                        }
                        if (error == null) continue;
                        ModelUtility.addError(errors, a, error);
                    }
                }
                for (Configuration c : runMode.getConfigurations()) {
                    String error = null;
                    if (c.getPid() == null || c.getPid().isEmpty()) {
                        error = "pid missing";
                    }
                    if (c.isSpecial() && c.getFactoryPid() != null) {
                        error = (error != null ? error + ", " : "") + "factory pid not allowed for special configuration";
                    }
                    if (c.getProperties().isEmpty()) {
                        error = (error != null ? error + ", " : "") + "configuration properties missing";
                    }
                    if (error == null) continue;
                    ModelUtility.addError(errors, c, error);
                }
            }
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors;
    }

    public static Model applyVariables(Model model, final VariableResolver resolver) {
        final HashMap collectedVars = new HashMap();
        VariableResolver variableCollector = new VariableResolver(){

            @Override
            public String resolve(Feature feature, String name) {
                String value = resolver.resolve(feature, name);
                if (value != null) {
                    HashMap<String, String> featureVars = (HashMap<String, String>)collectedVars.get(feature.getName());
                    if (featureVars == null) {
                        featureVars = new HashMap<String, String>();
                        collectedVars.put(feature.getName(), featureVars);
                    }
                    featureVars.put(name, value);
                }
                return value;
            }
        };
        new EffectiveModelProcessor(new ResolverOptions().variableResolver(variableCollector)).process(model);
        ModelProcessor variablesUpdater = new ModelProcessor(){

            @Override
            protected KeyValueMap<String> processVariables(KeyValueMap<String> variables, Feature newFeature) {
                KeyValueMap<String> newVariables = new KeyValueMap<String>();
                Map featureVars = (Map)collectedVars.get(newFeature.getName());
                if (featureVars != null) {
                    for (Map.Entry entry : featureVars.entrySet()) {
                        newVariables.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                return newVariables;
            }
        };
        return variablesUpdater.process(model);
    }

    public static Model applyArtifactVersions(Model model, final ArtifactVersionResolver resolver) {
        ModelProcessor versionUpdater = new ModelProcessor(){

            @Override
            protected Artifact processArtifact(Artifact artifact, Feature newFeature, RunMode newRunMode) {
                String newVersion = ModelResolveUtility.resolveArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType(), resolver);
                return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), newVersion, artifact.getClassifier(), artifact.getType(), artifact.getMetadata());
            }
        };
        return versionUpdater.process(model);
    }

    public static Map<Traceable, String> validateIncludingVersion(Model model) {
        Map<Traceable, String> errors = ModelUtility.validate(model);
        for (Feature feature : model.getFeatures()) {
            if (feature.getVersion() != null) continue;
            if (errors == null) {
                errors = new HashMap<Traceable, String>();
            }
            ModelUtility.addError(errors, feature, "Feature must have a version.");
        }
        return errors;
    }

    private static void addError(Map<Traceable, String> errors, Traceable object, String error) {
        String value = errors.get(object);
        errors.put(object, value == null ? error : value + " " + error);
    }

    public static final class ResolverOptions {
        private VariableResolver variableResolver;
        private ArtifactVersionResolver artifactVersionResolver;

        public VariableResolver getVariableResolver() {
            return this.variableResolver;
        }

        public ResolverOptions variableResolver(VariableResolver variableResolver) {
            this.variableResolver = variableResolver;
            return this;
        }

        public ArtifactVersionResolver getArtifactVersionResolver() {
            return this.artifactVersionResolver;
        }

        public ResolverOptions artifactVersionResolver(ArtifactVersionResolver dependencyVersionResolver) {
            this.artifactVersionResolver = dependencyVersionResolver;
            return this;
        }
    }

    public static interface ArtifactVersionResolver {
        public String resolve(Artifact var1);
    }

    public static interface VariableResolver {
        public String resolve(Feature var1, String var2);
    }
}

