/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Commentable;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;

public class ModelWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeComment(PrintWriter pw, Commentable commentable) throws IOException {
        if (commentable.getComment() != null) {
            try (LineNumberReader lnr = new LineNumberReader(new StringReader(commentable.getComment()));){
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    pw.print("# ");
                    pw.println(line);
                }
            }
        }
    }

    private static void writeRunMode(PrintWriter pw, RunMode runMode) {
        String[] rm = runMode.getNames();
        if (rm != null && rm.length > 0) {
            pw.print(" runModes=");
            boolean first = true;
            for (String mode : rm) {
                if (first) {
                    first = false;
                } else {
                    pw.print(",");
                }
                pw.print(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Writer writer, Model model) throws IOException {
        PrintWriter pw = new PrintWriter(writer);
        boolean firstFeature = true;
        for (Feature feature : model.getFeatures()) {
            if (firstFeature) {
                firstFeature = false;
            } else {
                pw.println();
            }
            ModelWriter.writeComment(pw, feature);
            pw.print("[feature name=");
            pw.print(feature.getName());
            if (!"plain".equals(feature.getType())) {
                pw.print(" type=");
                pw.print(feature.getType());
            }
            if (feature.getVersion() != null) {
                pw.print(" version=");
                pw.print(feature.getVersion());
            }
            pw.println("]");
            if (!feature.getVariables().isEmpty()) {
                pw.println();
                ModelWriter.writeComment(pw, feature.getVariables());
                pw.println("[variables]");
                for (Map.Entry entry : feature.getVariables()) {
                    pw.print("  ");
                    pw.print((String)entry.getKey());
                    pw.print("=");
                    pw.println((String)entry.getValue());
                }
            }
            for (RunMode runMode : feature.getRunModes()) {
                if (!runMode.getSettings().isEmpty()) {
                    pw.println();
                    ModelWriter.writeComment(pw, runMode.getSettings());
                    pw.print("[settings");
                    ModelWriter.writeRunMode(pw, runMode);
                    pw.println("]");
                    for (Map.Entry entry : runMode.getSettings()) {
                        pw.print("  ");
                        pw.print((String)entry.getKey());
                        pw.print("=");
                        pw.println((String)entry.getValue());
                    }
                }
                for (ArtifactGroup artifactGroup : runMode.getArtifactGroups()) {
                    if (artifactGroup.isEmpty()) continue;
                    pw.println();
                    ModelWriter.writeComment(pw, artifactGroup);
                    pw.print("[artifacts");
                    if (artifactGroup.getStartLevel() > 0) {
                        pw.print(" startLevel=");
                        pw.print(String.valueOf(artifactGroup.getStartLevel()));
                    }
                    ModelWriter.writeRunMode(pw, runMode);
                    pw.println("]");
                    for (Artifact ad : artifactGroup) {
                        ModelWriter.writeComment(pw, ad);
                        pw.print("  ");
                        pw.print(ad.toMvnUrl().substring(4));
                        if (!ad.getMetadata().isEmpty()) {
                            boolean first = true;
                            for (Map.Entry<String, String> entry : ad.getMetadata().entrySet()) {
                                if (first) {
                                    first = false;
                                    pw.print(" [");
                                } else {
                                    pw.print(", ");
                                }
                                pw.print(entry.getKey());
                                pw.print("=");
                                pw.print(entry.getValue());
                            }
                            pw.print("]");
                        }
                        pw.println();
                    }
                }
                if (runMode.getConfigurations().isEmpty()) continue;
                pw.println();
                ModelWriter.writeComment(pw, runMode.getConfigurations());
                pw.print("[configurations");
                ModelWriter.writeRunMode(pw, runMode);
                pw.println("]");
                boolean firstConfig = true;
                for (Configuration config : runMode.getConfigurations()) {
                    String configString;
                    String cfgMode;
                    if (firstConfig) {
                        firstConfig = false;
                    } else {
                        pw.println();
                    }
                    ModelWriter.writeComment(pw, config);
                    String raw = (String)config.getProperties().get(":rawconfig");
                    String format = (String)config.getProperties().get(":rawconfig.format");
                    if (format == null) {
                        format = "felixca";
                    }
                    if ((cfgMode = (String)config.getProperties().get(":rawconfig.mode")) == null) {
                        cfgMode = "overwrite";
                    }
                    pw.print("  ");
                    if (config.getFactoryPid() != null) {
                        pw.print(config.getFactoryPid());
                        pw.print("-");
                    }
                    pw.print(config.getPid());
                    boolean isDefaultFormat = "felixca".equals(format);
                    boolean isDefaultMode = "overwrite".equals(cfgMode);
                    if (!isDefaultFormat || !isDefaultMode) {
                        pw.print(" [");
                        if (!isDefaultFormat) {
                            pw.print("format=");
                            pw.print(format);
                            if (!isDefaultMode) {
                                pw.print(",");
                            }
                        }
                        if (!isDefaultMode) {
                            pw.print("mode=");
                            pw.print(cfgMode);
                        }
                        pw.print("]");
                    }
                    pw.println();
                    if (raw != null) {
                        configString = raw;
                    } else if (config.isSpecial()) {
                        configString = config.getProperties().get(config.getPid()).toString();
                    } else {
                        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                            ConfigurationHandler.write((OutputStream)os, config.getProperties());
                        }
                        configString = new String(os.toByteArray(), "UTF-8");
                    }
                    LineNumberReader lnr = new LineNumberReader(new StringReader(configString));
                    String line = null;
                    while ((line = lnr.readLine()) != null) {
                        if (line.trim().isEmpty()) continue;
                        pw.print("    ");
                        pw.println(line.trim());
                    }
                }
            }
            for (Section section : feature.getAdditionalSections()) {
                pw.println();
                pw.print("  [:");
                pw.print(section.getName());
                for (Map.Entry<String, String> entry : section.getAttributes().entrySet()) {
                    pw.print(' ');
                    pw.print(entry.getKey());
                    pw.print('=');
                    pw.print(entry.getValue());
                }
                pw.println("]");
                if (section.getContents() == null) continue;
                pw.println(section.getContents());
            }
        }
    }
}

