/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AclLine {
    private final Action action;
    private static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    public static final String PROP_PATHS = "paths";
    public static final String PROP_PRINCIPALS = "principals";
    public static final String PROP_PRIVILEGES = "privileges";
    public static final String PROP_NODETYPES = "nodetypes";
    private final Map<String, List<String>> properties;

    public AclLine(Action a) {
        this.action = a;
        this.properties = new TreeMap<String, List<String>>();
    }

    public Action getAction() {
        return this.action;
    }

    public List<String> getProperty(String name) {
        List<String> value = this.properties.get(name);
        return value != null ? value : EMPTY_LIST;
    }

    public void setProperty(String name, List<String> values) {
        this.properties.put(name, Collections.unmodifiableList(values));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + (Object)((Object)this.action) + " " + this.properties;
    }

    public static enum Action {
        REMOVE,
        REMOVE_ALL,
        DENY,
        ALLOW;

    }
}

