/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.PathSegmentDefinition;

public class CreatePath
extends Operation {
    private List<PathSegmentDefinition> pathDef = new ArrayList<PathSegmentDefinition>();
    private final String defaultPrimaryType;

    public CreatePath(String defaultPrimaryType) {
        this.defaultPrimaryType = defaultPrimaryType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.pathDef;
    }

    @Override
    protected String getParametersDescription() {
        return this.pathDef.toString();
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitCreatePath(this);
    }

    public void addSegment(String path, String primaryType) {
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].length() == 0) continue;
            String pt = this.defaultPrimaryType;
            if (i == segments.length - 1 && primaryType != null) {
                pt = primaryType;
            }
            this.pathDef.add(new PathSegmentDefinition(segments[i], pt));
        }
    }

    public List<PathSegmentDefinition> getDefinitions() {
        return Collections.unmodifiableList(this.pathDef);
    }
}

