/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherTagHandler
extends TagSupport {
    private static final long serialVersionUID = 6275972595573203863L;
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcherTagHandler.class);
    private Resource resource;
    private String path;
    private String resourceType;
    private String replaceSelectors;
    private String addSelectors;
    private String replaceSuffix;

    public int doEndTag() throws JspException {
        log.debug("AbstractDispatcherTagHandler.doEndTag");
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        RequestDispatcherOptions opts = new RequestDispatcherOptions();
        opts.setForceResourceType(this.resourceType);
        opts.setReplaceSelectors(this.replaceSelectors);
        opts.setAddSelectors(this.addSelectors);
        opts.setReplaceSuffix(this.replaceSuffix);
        if (this.path != null) {
            if (!this.path.startsWith("/")) {
                this.path = request.getResource().getPath() + "/" + this.path;
            }
            this.path = ResourceUtil.normalize(this.path);
        }
        if (this.resource == null) {
            if (this.path == null) {
                this.resource = request.getResource();
            } else {
                Resource tmp = request.getResourceResolver().resolve(this.path);
                if (tmp == null && this.resourceType != null) {
                    this.resource = new DispatcherSyntheticResource(request.getResourceResolver(), this.path, this.resourceType);
                    opts.remove("forceResourceType");
                }
            }
        }
        try {
            RequestDispatcher dispatcher = this.resource != null ? request.getRequestDispatcher(this.resource, opts) : request.getRequestDispatcher(this.path, opts);
            if (dispatcher != null) {
                JspSlingHttpServletResponseWrapper response = new JspSlingHttpServletResponseWrapper(this.pageContext);
                this.dispatch(dispatcher, (ServletRequest)request, (ServletResponse)response);
            } else {
                TagUtil.log(log, this.pageContext, "No content to include...", null);
            }
        }
        catch (JspTagException jte) {
            throw jte;
        }
        catch (IOException ioe) {
            throw new JspTagException((Throwable)ioe);
        }
        catch (ServletException ce) {
            throw new JspTagException(TagUtil.getRootCause(ce));
        }
        return 6;
    }

    protected abstract void dispatch(RequestDispatcher var1, ServletRequest var2, ServletResponse var3) throws IOException, ServletException, JspTagException;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.clear();
    }

    public void setResource(Resource rsrc) {
        if (rsrc == null) {
            throw new NullPointerException("Resource should not be null.");
        }
        this.resource = rsrc;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setResourceType(String rsrcType) {
        this.resourceType = rsrcType;
    }

    public void setReplaceSelectors(String selectors) {
        this.replaceSelectors = selectors;
    }

    public void setAddSelectors(String selectors) {
        this.addSelectors = selectors;
    }

    public void setReplaceSuffix(String suffix) {
        this.replaceSuffix = suffix;
    }

    public void release() {
        this.clear();
        super.release();
    }

    private void clear() {
        this.resource = null;
        this.resourceType = null;
        this.replaceSelectors = null;
        this.addSelectors = null;
        this.replaceSuffix = null;
        this.path = null;
    }

    private static class DispatcherSyntheticResource
    extends SyntheticResource {
        public DispatcherSyntheticResource(ResourceResolver resourceResolver, String path, String resourceType) {
            super(resourceResolver, path, resourceType);
        }

        @Override
        public String getResourceSuperType() {
            return ResourceUtil.getResourceSuperType(this.getResourceResolver(), this.getResourceType());
        }
    }
}

