/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.util.Iterator;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.jsp.taglib.helpers.XSSSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingFunctions {
    private static final Logger log = LoggerFactory.getLogger(SlingFunctions.class);

    public static Object adaptTo(Adaptable adaptable, String adapter) throws ClassNotFoundException {
        log.trace("adaptTo");
        Object adapted = null;
        if (adaptable != null) {
            log.debug("Adapting {} to class {}", (Object)adaptable, (Object)adapter);
            try {
                Class<?> adapterClass = SlingFunctions.loadClass(adapter);
                adapted = adaptable.adaptTo(adapterClass);
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + adapter, (Throwable)e);
            }
        } else {
            log.warn("Null adaptable specified");
        }
        return adapted;
    }

    public static String encode(String value, String mode) {
        return XSSSupport.encode(value, XSSSupport.getEncodingMode(mode));
    }

    public static Iterator<Resource> findResources(ResourceResolver resourceResolver, String query, String language) {
        log.trace("findResources");
        Iterator<Resource> resources = null;
        if (resourceResolver != null) {
            log.debug("Finding resources with query {} of type {}", (Object)query, (Object)language);
            resources = resourceResolver.findResources(query, language);
        } else {
            log.warn("Null resolver specified");
        }
        return resources;
    }

    public static Resource getRelativeResource(Resource base, String path) {
        log.trace("getRelativeResource");
        Resource relative = null;
        if (base != null) {
            log.debug("Getting relative resource of {} at path {}", (Object)base.getPath(), (Object)path);
            relative = base.getResourceResolver().getResource(base, path);
        } else {
            log.warn("Null base resource specified");
        }
        return relative;
    }

    public static final Resource getResource(ResourceResolver resolver, String path) {
        log.trace("getResource");
        log.debug("Getting resource at path {}", (Object)path);
        if (resolver == null) {
            throw new IllegalArgumentException("Null resource resolver");
        }
        return resolver.getResource(path);
    }

    public static final <E> E getValue(ValueMap properties, String key, Object defaultOrType) {
        if (defaultOrType instanceof Class) {
            return (E)properties.get(key, (Class)defaultOrType);
        }
        return (E)properties.get(key, defaultOrType);
    }

    public static final boolean hasChildren(Resource resource) {
        return resource != null ? resource.listChildren().hasNext() : false;
    }

    public static final Iterator<Resource> listChildren(Resource resource) {
        log.trace("listChildren");
        Iterator<Resource> children = null;
        if (resource != null) {
            log.debug("Listing children at path {}", (Object)resource.getPath());
            children = resource.listChildren();
        } else {
            log.warn("Null resource specified");
        }
        return children;
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }
}

