/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib.helpers;

import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;

public class XSSSupport {
    public static String encode(String unencoded, ENCODING_MODE mode) {
        String encoded = null;
        switch (mode) {
            case HTML: {
                encoded = ESAPI.encoder().encodeForHTML(unencoded);
                break;
            }
            case HTML_ATTR: {
                encoded = ESAPI.encoder().encodeForHTMLAttribute(unencoded);
                break;
            }
            case XML: {
                encoded = ESAPI.encoder().encodeForXML(unencoded);
                break;
            }
            case XML_ATTR: {
                encoded = ESAPI.encoder().encodeForXMLAttribute(unencoded);
                break;
            }
            case JS: {
                encoded = ESAPI.encoder().encodeForJavaScript(unencoded);
                break;
            }
        }
        return encoded;
    }

    public static ENCODING_MODE getEncodingMode(String modeStr) {
        return ENCODING_MODE.valueOf(StringUtils.upperCase((String)modeStr));
    }

    public static enum ENCODING_MODE {
        HTML,
        HTML_ATTR,
        XML,
        XML_ATTR,
        JS;

    }
}

