/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class VariableTracker<T> {
    private final Map<String, Stack<T>> variableData = new HashMap<String, Stack<T>>();
    private final Stack<String> declarationStack = new Stack();

    public boolean isDeclared(String name) {
        Stack<T> dataStack = this.variableData.get(name = name.toLowerCase());
        return dataStack != null;
    }

    public void pushVariable(String name, T data) {
        Stack<Object> dataStack = this.variableData.get(name = name.toLowerCase());
        if (dataStack == null) {
            dataStack = new Stack();
            this.variableData.put(name, dataStack);
        }
        dataStack.push(data);
        this.declarationStack.push(name);
    }

    public String popVariable() {
        String variable = this.declarationStack.pop();
        Stack<T> dataStack = this.variableData.get(variable);
        assert (dataStack != null);
        dataStack.pop();
        if (dataStack.isEmpty()) {
            this.variableData.remove(variable);
        }
        return variable;
    }

    public Map.Entry<String, T> peek() {
        String variable = this.declarationStack.peek();
        Stack<T> dataStack = this.variableData.get(variable);
        assert (dataStack != null);
        T data = dataStack.peek();
        return new AbstractMap.SimpleImmutableEntry<String, T>(variable, data);
    }

    public boolean isEmpty() {
        return this.declarationStack.isEmpty();
    }

    public T get(String name) {
        Stack<T> dataStack = this.variableData.get(name = name.toLowerCase());
        if (dataStack == null) {
            return null;
        }
        assert (!dataStack.isEmpty());
        return dataStack.peek();
    }

    public boolean isInScope(String name) {
        return this.variableData.get(name = name.toLowerCase()) != null;
    }

    public List<T> getAll(String name) {
        Stack<T> dataStack = this.variableData.get(name = name.toLowerCase());
        if (dataStack == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(dataStack);
    }

    public int getOccurrenceCount(String name) {
        Stack<T> dataStack = this.variableData.get(name = name.toLowerCase());
        if (dataStack == null) {
            return 0;
        }
        return dataStack.size();
    }
}

