/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandHandler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.CommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.StatefulVisitor;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.CompilationOutput;
import org.apache.sling.scripting.sightly.java.compiler.impl.CodeGenVisitor;
import org.apache.sling.scripting.sightly.java.compiler.impl.CommandVisitorHandler;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaClassTemplate;
import org.apache.sling.scripting.sightly.java.compiler.impl.UnitBuilder;

public final class JavaClassBackendCompiler
implements BackendCompiler {
    private static final String COMPILED_UNIT_TEMPLATE = "templates/compiled_unit_template.txt";
    private static final String SUBTEMPLATE = "templates/subtemplate.txt";
    private static final String mainTemplate;
    private static final String childTemplate;
    private UnitBuilder unitBuilder = new UnitBuilder();

    @Override
    public void handle(CommandStream stream) {
        StatefulVisitor statefulVisitor = new StatefulVisitor();
        final CodeGenVisitor visitor = new CodeGenVisitor(this.unitBuilder, statefulVisitor.getControl());
        statefulVisitor.initializeWith((CommandVisitor)visitor);
        stream.addHandler((CommandHandler)new CommandVisitorHandler(statefulVisitor){

            public void onDone() {
                super.onDone();
                visitor.finish();
            }
        });
    }

    public String build(ClassInfo classInfo) {
        CompilationOutput compilationOutput = this.unitBuilder.build();
        JavaClassTemplate mainTemplate = this.newMainTemplate();
        mainTemplate.setPackageName(classInfo.getPackageName());
        mainTemplate.setClassName(classInfo.getSimpleClassName());
        this.processCompilationResult(compilationOutput, mainTemplate);
        return mainTemplate.toString();
    }

    private void processCompilationResult(CompilationOutput result, JavaClassTemplate mainTemplate) {
        mainTemplate.writeMainBody(result.getMainBody());
        for (Map.Entry<String, CompilationOutput> entry : result.getSubTemplates().entrySet()) {
            JavaClassTemplate childTemplate = this.newChildTemplate();
            this.processCompilationResult(entry.getValue(), childTemplate);
            mainTemplate.writeSubTemplate(entry.getKey(), childTemplate.toString());
        }
    }

    private JavaClassTemplate newMainTemplate() {
        return new JavaClassTemplate(mainTemplate);
    }

    private JavaClassTemplate newChildTemplate() {
        return new JavaClassTemplate(childTemplate);
    }

    static {
        try {
            mainTemplate = IOUtils.toString((InputStream)JavaClassTemplate.class.getClassLoader().getResourceAsStream(COMPILED_UNIT_TEMPLATE), (String)"UTF-8");
            childTemplate = IOUtils.toString((InputStream)JavaClassTemplate.class.getClassLoader().getResourceAsStream(SUBTEMPLATE), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

