/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class JavaEscapeUtils {
    private static final Set<String> javaKeywords = new HashSet<String>(){
        {
            this.add("abstract");
            this.add("assert");
            this.add("boolean");
            this.add("break");
            this.add("byte");
            this.add("case");
            this.add("catch");
            this.add("char");
            this.add("class");
            this.add("const");
            this.add("continue");
            this.add("default");
            this.add("do");
            this.add("double");
            this.add("else");
            this.add("enum");
            this.add("extends");
            this.add("final");
            this.add("finally");
            this.add("float");
            this.add("for");
            this.add("goto");
            this.add("if");
            this.add("implements");
            this.add("import");
            this.add("instanceof");
            this.add("int");
            this.add("interface");
            this.add("long");
            this.add("native");
            this.add("new");
            this.add("package");
            this.add("private");
            this.add("protected");
            this.add("public");
            this.add("return");
            this.add("short");
            this.add("static");
            this.add("strictfp");
            this.add("super");
            this.add("switch");
            this.add("synchronized");
            this.add("this");
            this.add("throw");
            this.add("throws");
            this.add("transient");
            this.add("try");
            this.add("void");
            this.add("volatile");
            this.add("while");
        }
    };

    public static String makeJavaIdentifier(String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JavaEscapeUtils.mangleChar(ch));
        }
        if (JavaEscapeUtils.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    public static String mangleChar(char ch) {
        return String.format("__%04x__", ch);
    }

    public static char unmangle(String mangled) {
        String toProcess = mangled.replaceAll("__", "");
        return (char)Integer.parseInt(toProcess, 16);
    }

    public static String makeJavaPackage(String scriptName) {
        String[] classNameComponents = StringUtils.split((String)scriptName, (char)'/');
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JavaEscapeUtils.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    public static boolean isJavaKeyword(String key) {
        return javaKeywords.contains(key);
    }
}

