/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.render;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeObjectModel
implements RuntimeObjectModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRuntimeObjectModel.class);
    public static final Set<Class<?>> PRIMITIVE_CLASSES = Collections.unmodifiableSet(new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Void.class);
        }
    });
    public static final String TO_STRING_METHOD = "toString";

    @Override
    public boolean isPrimitive(Object obj) {
        return PRIMITIVE_CLASSES.contains(obj.getClass());
    }

    @Override
    public boolean isDate(Object target) {
        return target instanceof Date || target instanceof Calendar;
    }

    @Override
    public boolean isNumber(Object target) {
        return target instanceof Number;
    }

    @Override
    public boolean isCollection(Object target) {
        return target instanceof Collection || target instanceof Object[] || target instanceof Iterable || target instanceof Iterator;
    }

    @Override
    public Object resolveProperty(Object target, Object property) {
        Object resolved = property instanceof Number ? this.getIndex(target, ((Number)property).intValue()) : this.getProperty(target, property);
        return resolved;
    }

    @Override
    public boolean toBoolean(Object object) {
        return this.toBooleanInternal(object);
    }

    @Override
    public Number toNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return null;
    }

    @Override
    public Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        return null;
    }

    @Override
    public String toString(Object target) {
        return this.objectToString(target);
    }

    @Override
    public Collection<Object> toCollection(Object object) {
        return this.obtainCollection(object);
    }

    @Override
    public Map toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof Record) {
            HashMap map = new HashMap();
            Record record = (Record)object;
            Set<String> properties = record.getPropertyNames();
            for (String property : properties) {
                map.put(property, record.getProperty(property));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    protected String objectToString(Object obj) {
        String output = "";
        if (obj != null) {
            if (obj instanceof String) {
                output = (String)obj;
            } else if (this.isPrimitive(obj)) {
                output = obj.toString();
            } else {
                if (obj instanceof Enum) {
                    return ((Enum)obj).name();
                }
                Collection<Object> col = this.obtainCollection(obj);
                if (col != null) {
                    output = this.collectionToString(col);
                }
            }
        }
        return output;
    }

    protected Object getProperty(Object target, Object propertyObj) {
        String property = this.toString(propertyObj);
        if (StringUtils.isEmpty((String)property)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (target == null) {
            return null;
        }
        Object result = null;
        if (target instanceof Map) {
            result = this.getMapProperty((Map)target, property);
        }
        if (result == null && target instanceof Record) {
            result = ((Record)target).getProperty(property);
        }
        if (result == null) {
            result = this.getObjectProperty(target, property);
        }
        return result;
    }

    protected Collection<Object> obtainCollection(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof Object[]) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).keySet();
        }
        if (obj instanceof Record) {
            return ((Record)obj).getPropertyNames();
        }
        if (obj instanceof Enumeration) {
            return Collections.list((Enumeration)obj);
        }
        if (obj instanceof Iterator) {
            return this.fromIterator((Iterator)obj);
        }
        if (obj instanceof Iterable) {
            Iterable iterable = (Iterable)obj;
            return this.fromIterator(iterable.iterator());
        }
        if (obj instanceof String || obj instanceof Number) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            return list;
        }
        return Collections.emptyList();
    }

    protected String collectionToString(Collection<?> col) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Object o : col) {
            builder.append(prefix).append(this.objectToString(o));
            prefix = ",";
        }
        return builder.toString();
    }

    protected Collection<Object> fromIterator(Iterator<Object> iterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    protected boolean toBooleanInternal(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue() != 0.0;
        }
        String s = obj.toString().trim();
        if ("".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            return Boolean.parseBoolean(s);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() > 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() > 0;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return ((Iterator)obj).hasNext();
        }
        return !(obj instanceof Object[]) || ((Object[])obj).length > 0;
    }

    protected Object getIndex(Object obj, int index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        Collection<Object> collection = this.toCollection(obj);
        if (collection instanceof List) {
            return this.getIndexSafe((List)collection, index);
        }
        return null;
    }

    protected Object getIndexSafe(List list, int index) {
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    protected Object getMapProperty(Map map, String property) {
        return map.get(property);
    }

    protected Object getObjectProperty(Object obj, String property) {
        Object result = this.getObjectNoArgMethod(obj, property);
        if (result == null) {
            result = AbstractRuntimeObjectModel.getField(obj, property);
        }
        return result;
    }

    protected static Object getField(Object obj, String property) {
        Class<?> cls = obj.getClass();
        if (cls.isArray() && "length".equals(property)) {
            return Array.getLength(obj);
        }
        try {
            Field field = cls.getDeclaredField(property);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object getObjectNoArgMethod(Object obj, String property) {
        Class<?> cls = obj.getClass();
        Method method = AbstractRuntimeObjectModel.findMethod(cls, property);
        if (method != null) {
            method = this.extractMethodInheritanceChain(cls, method);
            try {
                return method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot access method " + property + " on object " + obj.toString(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Method findMethod(Class<?> cls, String baseName) {
        Method[] publicMethods = cls.getMethods();
        String capitalized = StringUtils.capitalize((String)baseName);
        for (Method m : publicMethods) {
            String methodName;
            if (m.getParameterTypes().length != 0 || !baseName.equals(methodName = m.getName()) && !("get" + capitalized).equals(methodName) && !("is" + capitalized).equals(methodName)) continue;
            if (!AbstractRuntimeObjectModel.isMethodAllowed(m)) break;
            return m;
        }
        return null;
    }

    protected static boolean isMethodAllowed(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class || TO_STRING_METHOD.equals(method.getName());
    }

    protected Method extractMethodInheritanceChain(Class type, Method m) {
        Class<?>[] iFaces;
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        for (Class<?> iFace : iFaces = type.getInterfaces()) {
            Method mp = this.getClassMethod(iFace, m);
            if (mp == null) continue;
            return mp;
        }
        return this.getClassMethod(type.getSuperclass(), m);
    }

    protected Method getClassMethod(Class<?> clazz, Method m) {
        try {
            Method mp = clazz.getMethod(m.getName(), m.getParameterTypes());
            mp = this.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
            if (mp != null) {
                return mp;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

