/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.servlets.post.AbstractPostResponse;

public class HtmlResponse
extends AbstractPostResponse {
    private static final String PN_CHANGE_LOG = "changeLog";
    private static final String TEMPLATE_NAME = "HtmlResponse.html";
    private static final String NO_GO_BACK_TEMPLATE_NAME = "HtmlNoGoBackResponse.html";
    private final StringBuilder changes = new StringBuilder();

    @Override
    public void onChange(String type, String ... arguments) {
        this.changes.append(type);
        String delim = "(";
        for (String a : arguments) {
            this.changes.append(delim);
            this.changes.append('\"');
            this.changes.append(a);
            this.changes.append('\"');
            delim = ", ";
        }
        this.changes.append(");<br/>");
    }

    @Override
    protected void doSend(HttpServletResponse response) throws IOException {
        int read;
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        this.changes.insert(0, "<pre>");
        this.changes.append("</pre>");
        this.setProperty(PN_CHANGE_LOG, this.changes.toString());
        PrintWriter out = response.getWriter();
        String templateName = this.isSafeReferer() ? TEMPLATE_NAME : NO_GO_BACK_TEMPLATE_NAME;
        InputStream template = this.getClass().getResourceAsStream(templateName);
        BufferedReader in = new BufferedReader(new InputStreamReader(template));
        StringBuilder varBuffer = new StringBuilder();
        int state = 0;
        while ((read = ((Reader)in).read()) >= 0) {
            char c = (char)read;
            switch (state) {
                case 0: {
                    if (c == '$') {
                        state = 1;
                        break;
                    }
                    ((Writer)out).write(c);
                    break;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        break;
                    }
                    state = 0;
                    ((Writer)out).write(36);
                    ((Writer)out).write(c);
                    break;
                }
                case 2: {
                    if (c == '}') {
                        state = 0;
                        Object prop = this.getProperty(varBuffer.toString());
                        if (prop != null) {
                            ((Writer)out).write(ResponseUtil.escapeXml(prop.toString()));
                        }
                        varBuffer.setLength(0);
                        break;
                    }
                    varBuffer.append(c);
                }
            }
        }
        ((Reader)in).close();
        ((Writer)out).flush();
    }
}

