/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

@ProviderType
public class CommerceQuery {
    public static final String PARAM_QUERYTEXT = "q";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PAGESIZE = "pagesize";
    public static final String PARAM_SORTID = "sort";
    protected String queryText;
    protected int page;
    protected int pageSize;
    protected String sortId;
    protected Map<String, List<String>> facets;

    protected CommerceQuery() {
    }

    public CommerceQuery(HttpServletRequest request) {
        this.queryText = request.getParameter(PARAM_QUERYTEXT);
        if (StringUtils.isNumeric(request.getParameter(PARAM_PAGE))) {
            this.page = Integer.parseInt(request.getParameter(PARAM_PAGE));
        }
        if (StringUtils.isNumeric(request.getParameter(PARAM_PAGESIZE))) {
            this.pageSize = Integer.parseInt(request.getParameter(PARAM_PAGESIZE));
        }
        this.sortId = request.getParameter(PARAM_SORTID);
        this.facets = new HashMap<String, List<String>>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("facet_")) continue;
            String facetId = ((String)entry.getKey()).substring("facet_".length());
            List<String> values = Arrays.asList((String[])entry.getValue());
            this.facets.put(facetId, values);
        }
    }

    public String getQueryText() {
        return this.queryText;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSortId() {
        return this.sortId;
    }

    public Map<String, List<String>> getFacets() {
        return this.facets;
    }

    public static class Builder {
        private CommerceQuery query = new CommerceQuery();

        public Builder setQueryText(String queryText) {
            this.query.queryText = queryText;
            return this;
        }

        public Builder setPage(int page) {
            this.query.page = page;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.query.pageSize = pageSize;
            return this;
        }

        public void setSortId(String sortId) {
            this.query.sortId = sortId;
        }

        public CommerceQuery build() throws IllegalStateException {
            if (this.query.queryText == null) {
                throw new IllegalStateException("Cannot create query withthout queryText");
            }
            CommerceQuery result = this.query;
            this.query = null;
            return result;
        }
    }
}

