/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common.collection;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.collection.ProductCollection;
import com.adobe.cq.commerce.api.collection.ProductCollectionManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.collection.ResourceCollection;
import org.apache.sling.resource.collection.ResourceCollectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractProductCollection
implements ProductCollection {
    protected final Logger log = LoggerFactory.getLogger(AbstractProductCollection.class);
    protected Resource resource;
    protected ValueMap properties;
    protected ModifiableValueMap modifiableProperties;
    protected ResourceResolver resolver;
    protected ResourceCollection resourceCollection;
    protected ResourceCollectionManager resourceCollectionManager;
    protected ProductCollectionManager productCollectionManager;

    public AbstractProductCollection(Resource resource) {
        this.resource = resource;
        this.properties = resource.adaptTo(ValueMap.class);
        this.modifiableProperties = resource.adaptTo(ModifiableValueMap.class);
        this.resolver = resource.getResourceResolver();
        this.resourceCollectionManager = this.resolver.adaptTo(ResourceCollectionManager.class);
        this.resourceCollection = this.resourceCollectionManager.getCollection(resource);
        this.productCollectionManager = this.resolver.adaptTo(ProductCollectionManager.class);
    }

    @Override
    public String getTitle() {
        return this.properties.get("jcr:title", "");
    }

    @Override
    public String getDescription() {
        return this.properties.get("jcr:description", "");
    }

    @Override
    public String getType() {
        return this.properties.get("commerce.collection.type", "");
    }

    @Override
    public String getPath() {
        return this.resourceCollection.getPath();
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.properties);
        return props;
    }

    @Override
    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.properties.get(key, type);
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        return this.properties.get(key, defaultValue);
    }

    @Override
    public void setProperties(Map<String, Object> properties) throws CommerceException {
        this.modifiableProperties.putAll(properties);
        this.modifiableProperties.put("jcr:lastModifiedBy", this.resolver.getUserID());
        this.modifiableProperties.put("jcr:lastModified", Calendar.getInstance());
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new CommerceException("Failed to set the collection properties", e);
        }
        this.log.debug("Properties were set for collection at {}", (Object)this.getPath());
    }

    @Override
    public void setProperty(String key, Object value) throws CommerceException {
        this.modifiableProperties.put(key, value);
        this.modifiableProperties.put("jcr:lastModifiedBy", this.resolver.getUserID());
        this.modifiableProperties.put("jcr:lastModified", Calendar.getInstance());
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new CommerceException("Failed to set the collection property", e);
        }
        this.log.debug("Property {} was set for collection at {}", (Object)key, (Object)this.getPath());
    }

    @Override
    public boolean contains(Product product) {
        Iterator<Product> products = this.getProducts();
        while (products.hasNext()) {
            Product p = products.next();
            if (!p.getPath().equals(product.getPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> getDirectReferences() {
        ArrayList<String> references = new ArrayList<String>();
        Iterator<Resource> resources = this.resourceCollection.getResources();
        while (resources.hasNext()) {
            Resource r = resources.next();
            String path = r.getPath();
            references.add(path);
        }
        return references.iterator();
    }

    @Override
    public boolean hasDirectReference(String path) {
        Iterator<String> references = this.getDirectReferences();
        while (references.hasNext()) {
            String ref = references.next();
            if (!ref.equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(String path) throws CommerceException {
        this.checkItemType(path);
        Resource res = this.resolver.getResource(path);
        boolean added = false;
        try {
            added = this.resourceCollection.add(res);
            this.modifiableProperties.put("jcr:lastModifiedBy", this.resolver.getUserID());
            this.modifiableProperties.put("jcr:lastModified", Calendar.getInstance());
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new CommerceException("Cannot add item " + path + " to collection " + this.getPath());
        }
        if (!added) {
            throw new CommerceException("Cannot add item " + path + " to collection " + this.getPath());
        }
    }

    @Override
    public void remove(String path) throws CommerceException {
        Resource productRes = this.resolver.getResource(path);
        boolean removed = false;
        try {
            this.modifiableProperties.put("jcr:lastModifiedBy", this.resolver.getUserID());
            this.modifiableProperties.put("jcr:lastModified", Calendar.getInstance());
            removed = this.resourceCollection.remove(productRes);
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new CommerceException("Cannot remove item " + path + " from collection " + this.getPath());
        }
        if (!removed) {
            throw new CommerceException("Cannot remove item " + path + " from collection " + this.getPath());
        }
    }

    @Override
    public void orderBefore(String srcPath, String destPath) {
        Resource srcProductRes = this.resolver.getResource(srcPath);
        Resource destProductRes = this.resolver.getResource(destPath);
        this.resourceCollection.orderBefore(srcProductRes, destProductRes);
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            this.log.error("Could not order item {} before item {}", (Object)srcPath, (Object)destPath);
        }
    }

    public void checkItemType(String path) {
        Resource res = this.resolver.getResource(path);
        if (res == null) {
            throw new IllegalArgumentException("There is no resource at " + path);
        }
        Product product = res.adaptTo(Product.class);
        if (product == null) {
            throw new IllegalArgumentException("Cannot add item " + path + " to collection " + this.getPath() + " as it is not a product.");
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ProductCollection && ((ProductCollection)obj).getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

