/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.msm.ui.rendercondition;

import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityRenderCondition
implements RenderCondition {
    private static final Logger log = LoggerFactory.getLogger(CapabilityRenderCondition.class);
    private Session session;
    private String[] paths;
    private String[] methods;

    public CapabilityRenderCondition(Session session, String[] paths, String[] methods) throws RepositoryException {
        this.session = session;
        this.paths = paths;
        this.methods = methods;
    }

    @Override
    public boolean check() throws ServletException {
        try {
            for (String path : this.paths) {
                if (!this.session.nodeExists(path)) continue;
                Node node = this.session.getNode(path);
                if (node == null) {
                    return false;
                }
                for (String method : this.methods) {
                    if (this.session.hasCapability(method, (Object)node, new Object[]{"testObj"})) continue;
                    return false;
                }
            }
            return true;
        }
        catch (RepositoryException e) {
            log.error("Error while accessing a node ", e);
            return false;
        }
    }
}

