/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.msm.ui.util;

import com.adobe.cq.msm.ui.util.StatusDetails;
import com.adobe.cq.wcm.launches.utils.LaunchUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.BlueprintManager;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.cq.wcm.msm.api.LiveStatus;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.RangeIterator;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONStringer;

public class MSMUtil {
    public static final String MSM_STATUS_STNCHRONIZED = "msm-status-synchronized";
    public static final String MSM_STATUS_SOURCE_MODIFIED = "msm-status-src-modified";
    public static final String MSM_STATUS_TARGET_MODIFIED = "msm-status-target-modified";
    public static final String MSM_STATUS_NEW = "msm-status-new";
    public static final String MSM_STATUS_TARGET_DOES_NOT_EXIST = "msm-status-target-does-not-exist";
    public static final String MSM_STATUS_CANCELLED = "msm-status-cancelled";
    public static final String MSM_BLUEPRINT_EDIT_PAGE_ACTION = "cq-wcm-msm-all-live-copies-openpage-activator";
    public static final String MSM_BLUEPRINT_ROLLOUT_ACTION = "cq-wcm-msm-all-live-copies-rollout-activator";
    public static final String MSM_LIVECOPY_EDIT_PAGE_ACTION = "cq-wcm-msm-all-live-copies-openlivecopy-activator";
    public static final String MSM_LIVECOPY_RELATIONSHIP_ACTION = "cq-wcm-msm-all-live-copies-relationship-activator";
    public static final String MSM_LIVECOPY_SYNC_ACTION = "cq-wcm-msm-all-live-copies-sync-activator";
    public static final String MSM_LIVECOPY_RESET_ACTION = "cq-wcm-msm-all-live-copies-reset-activator";
    public static final String MSM_LIVECOPY_SUSPEND_ACTION = "cq-wcm-msm-all-live-copies-suspend-activator";
    public static final String MSM_LIVECOPY_RESUME_ACTION = "cq-wcm-msm-all-live-copies-resume-activator";
    public static final String MSM_LIVECOPY_DETACH_ACTION = "cq-wcm-msm-all-live-copies-detach-activator";
    public static HashMap<String, StatusDetails> STATUS_DETAIL_MAP = new HashMap<String, StatusDetails>(){
        {
            this.put(MSMUtil.MSM_STATUS_STNCHRONIZED, new StatusDetails("checkCircle", "cq-icon-green", "LIVE COPY UP TO DATE"));
            this.put(MSMUtil.MSM_STATUS_SOURCE_MODIFIED, new StatusDetails("clock", "cq-icon-black", "BLUEPRINT MODIFIED"));
            this.put(MSMUtil.MSM_STATUS_TARGET_MODIFIED, new StatusDetails("clock", "cq-icon-black", "LIVE COPY MODIFIED"));
            this.put(MSMUtil.MSM_STATUS_NEW, new StatusDetails("addCircle", "cq-icon-black", "LIVE COPY LOCALLY CREATED"));
            this.put(MSMUtil.MSM_STATUS_TARGET_DOES_NOT_EXIST, new StatusDetails("exclude", "cq-icon-grey", "LIVE COPY DOES NOT EXIST"));
            this.put(MSMUtil.MSM_STATUS_CANCELLED, new StatusDetails("closeCircle", "cq-icon-red", "INHERITANCE CANCELLED"));
        }
    };

    public static boolean isPage(Resource resource) {
        return resource != null && "cq:Page".equals(resource.getResourceType());
    }

    public static boolean isFolder(Resource resource) {
        return resource != null && (resource.isResourceType("sling:Folder") || resource.isResourceType("sling:OrderedFolder") || resource.isResourceType("nt:folder"));
    }

    public static String getTitle(ResourceResolver resourceResolver, Resource resource) {
        if (MSMUtil.isPage(resource)) {
            PageManager pageManager = resourceResolver.adaptTo(PageManager.class);
            Page page = pageManager.getPage(resource.getPath());
            return page.getTitle();
        }
        return "title";
    }

    public static String getThumbnailUrl(ResourceResolver resourceResolver, Resource resource, int width, int height) {
        String ck = "";
        if (MSMUtil.isPage(resource)) {
            Calendar cal;
            PageManager pageManager = resourceResolver.adaptTo(PageManager.class);
            Page page = pageManager.getPage(resource.getPath());
            ValueMap metadata = page.getProperties("image/file/jcr:content");
            if (metadata != null && (cal = (Calendar)((Object)metadata.get("jcr:lastModified", Calendar.class))) != null) {
                ck = "" + cal.getTimeInMillis() / 1000L;
            }
            return Text.escapePath(page.getPath()) + ".thumb." + width + "." + height + ".png?ck=" + ck;
        }
        return "";
    }

    public static String getLivecopyActionRels(String statusMesg) throws JSONException {
        if (statusMesg.equals(MSM_STATUS_TARGET_DOES_NOT_EXIST) || statusMesg.equals(MSM_STATUS_NEW)) {
            return "";
        }
        JSONArray actionRels = new JSONArray();
        actionRels.put(MSM_LIVECOPY_EDIT_PAGE_ACTION);
        actionRels.put(MSM_LIVECOPY_RELATIONSHIP_ACTION);
        if (statusMesg.equals(MSM_STATUS_CANCELLED)) {
            actionRels.put(MSM_LIVECOPY_RESUME_ACTION).put(MSM_LIVECOPY_DETACH_ACTION);
        } else {
            actionRels.put(MSM_LIVECOPY_SYNC_ACTION).put(MSM_LIVECOPY_RESET_ACTION).put(MSM_LIVECOPY_SUSPEND_ACTION).put(MSM_LIVECOPY_DETACH_ACTION);
        }
        return actionRels.toString();
    }

    public static String getBlueprintActionRels(boolean isBlueprint) {
        String rowActionRels = MSM_BLUEPRINT_EDIT_PAGE_ACTION;
        if (isBlueprint) {
            rowActionRels = rowActionRels + " " + MSM_BLUEPRINT_ROLLOUT_ACTION;
        }
        return rowActionRels;
    }

    public static boolean isResourceBlueprint(BlueprintManager bpm, LiveRelationshipManager relationMgr, Resource currResource) throws WCMException {
        if (bpm.getContainingBlueprint(currResource.getPath()) == null || !relationMgr.isSource(currResource)) {
            return false;
        }
        RangeIterator relationships = relationMgr.getLiveRelationships(currResource, null, null);
        while (relationships.hasNext()) {
            LiveRelationship currRelationship = (LiveRelationship)relationships.next();
            String lcPath = currRelationship.getLiveCopy().getPath();
            if (LaunchUtils.isLaunchResourcePath(lcPath)) continue;
            return true;
        }
        return false;
    }

    public static String getStatus(LiveRelationshipManager relationMgr, Resource source, String targetFilter) throws Exception {
        RangeIterator pageRelations = relationMgr.getLiveRelationships(source, targetFilter, null);
        if (pageRelations == null) {
            return MSM_STATUS_TARGET_DOES_NOT_EXIST;
        }
        while (pageRelations.hasNext()) {
            LiveRelationship currRelationship = (LiveRelationship)pageRelations.next();
            if (!currRelationship.getTargetPath().equals(targetFilter)) continue;
            LiveStatus status = currRelationship.getStatus();
            Map<String, Boolean> advanceStatus = status.getAdvancedStatus();
            if (!status.isCancelled()) {
                if (status.isTargetExisting() && status.isSourceExisting() && !MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isTargetManuallyCreated")) {
                    if (MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isSourceModified")) {
                        return MSM_STATUS_SOURCE_MODIFIED;
                    }
                    if (MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isTargetModified")) {
                        return MSM_STATUS_TARGET_MODIFIED;
                    }
                    return MSM_STATUS_STNCHRONIZED;
                }
                if (status.isSourceExisting()) {
                    if (MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isTargetManuallyCreated")) {
                        return MSM_STATUS_NEW;
                    }
                    return MSM_STATUS_TARGET_DOES_NOT_EXIST;
                }
                if (!MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isSourceDeleted")) continue;
                return MSM_STATUS_CANCELLED;
            }
            if (!MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isSourceExisting") && MSMUtil.getAdvanceStatusValue(advanceStatus, "msm:isSourceDeleted")) continue;
            return MSM_STATUS_CANCELLED;
        }
        return MSM_STATUS_TARGET_DOES_NOT_EXIST;
    }

    public static Map<String, String> getFilteredNames(RangeIterator rootRelations) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        Object previousPath = null;
        String[] prefix = null;
        String prefixStr = "";
        while (rootRelations.hasNext()) {
            LiveRelationship relation = (LiveRelationship)rootRelations.next();
            String lcPath = relation.getLiveCopy().getPath();
            if (prefix == null) {
                prefix = Text.explode(lcPath, 47);
            } else {
                int i;
                prefixStr = "";
                String[] pathExploded = Text.explode(lcPath, 47);
                for (i = 0; i < prefix.length && i < pathExploded.length && prefix[i] != null && pathExploded[i].equals(prefix[i]); ++i) {
                    prefixStr = prefixStr + "/" + prefix[i];
                }
                while (i < prefix.length) {
                    prefix[i] = null;
                    ++i;
                }
            }
            names.put(relation.getTargetPath(), lcPath);
        }
        for (String key : names.keySet()) {
            String path = (String)names.get(key);
            if ((path = path.substring(prefixStr.length() + 1)).startsWith("content/")) {
                path = path.substring(8);
            }
            names.put(key, path);
        }
        return names;
    }

    public static String getRelativeSourcePath(Resource rootResource, Resource currResource) {
        String relSourcePath = currResource.getPath().replaceFirst(rootResource.getPath(), "");
        if (relSourcePath.startsWith("/")) {
            relSourcePath = relSourcePath.replaceFirst("/", "");
        }
        return relSourcePath;
    }

    private static boolean getAdvanceStatusValue(Map<String, Boolean> advanceStatus, String param) {
        return advanceStatus.containsKey(param) && advanceStatus.get(param) != false;
    }

    public static Map<String, String> getLiveCopyCellAttributes(XSSAPI xssAPI, String liveCopyPath, String resourcePath, String statusMesg) throws JSONException {
        HashMap<String, String> cellAttrbs = new HashMap<String, String>();
        cellAttrbs.put("is", "coral-table-cell");
        String cellActionRels = MSMUtil.getLivecopyActionRels(statusMesg);
        String relationshipDetailJson = new JSONStringer().object().key("source").value(xssAPI.getValidHref(resourcePath)).key("target").value(xssAPI.getValidHref(liveCopyPath)).endObject().toString();
        cellAttrbs.put("data-relationship", relationshipDetailJson);
        if (!cellActionRels.equals("")) {
            cellAttrbs.put("data-actionrels", cellActionRels);
        }
        return cellAttrbs;
    }
}

