/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.apps.we_retail.util;

import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private final InputStream delegate;
    private final long size;
    private long position;

    public BoundedInputStream(InputStream delegate, long size) {
        this.delegate = delegate;
        this.size = size;
    }

    @Override
    public int read() throws IOException {
        if (this.isSizeExceeded()) {
            throw new IOException("Input stream exceeded size of " + this.size + " bytes");
        }
        int result = this.delegate.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    public long getSize() {
        return this.size;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean isSizeExceeded() {
        if (this.size < 0L) {
            return false;
        }
        return this.position > this.size;
    }
}

