/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.apps.we_retail.util;

import com.adobe.cq.screens.apps.we_retail.util.BoundedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticContentZipUtils {
    private static StaticContentZipUtils sharedInstance;
    private static final Logger log;
    private static final String MIME_TYPE_ZIP = "application/zip";
    private static final String INDEX_FILE_NAME = "index.html";
    private ResourceUtilWrapper resourceUtil = ResourceUtilWrapper.getSharedInstance();
    private MimeTypeService mimeTypeService;

    private StaticContentZipUtils(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public static StaticContentZipUtils getOrCreateSharedInstance(MimeTypeService mimeTypeService) {
        if (null == sharedInstance) {
            sharedInstance = new StaticContentZipUtils(mimeTypeService);
        }
        return sharedInstance;
    }

    public boolean isZip(Node node) {
        try {
            Node content = node.getNode("{http://www.jcp.org/jcr/1.0}content");
            String mimeType = content.getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString();
            return MIME_TYPE_ZIP.equals(mimeType);
        }
        catch (RepositoryException e) {
            log.error("Repository exception when checking for zip content", e);
            return false;
        }
    }

    public boolean zipContainsFile(Node node, String fileName) throws IOException {
        try {
            boolean success = false;
            ZipInputStream zin = this.getInputStream(node);
            ZipEntry entry = null;
            while (null != (entry = zin.getNextEntry()) && !success) {
                if (entry.isDirectory()) continue;
                if (entry.getName().equals(fileName)) {
                    success = true;
                }
                zin.closeEntry();
            }
            return success;
        }
        catch (RepositoryException e) {
            log.error("Repository exception when checking for zip content", e);
            return false;
        }
    }

    private ZipInputStream getInputStream(Node node) throws RepositoryException {
        Node resNode = node.getNode("{http://www.jcp.org/jcr/1.0}content");
        Binary archiveContent = resNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        return new ZipInputStream(archiveContent.getStream());
    }

    public void extract(Node node, Node destination, ResourceResolver resourceResolver) throws RepositoryException, IOException {
        ZipInputStream zin = this.getInputStream(node);
        String rootPath = destination.getPath() + "/";
        ZipEntry entry = null;
        while (null != (entry = zin.getNextEntry())) {
            if (entry.isDirectory()) {
                this.handleDir(entry, rootPath, resourceResolver);
            } else {
                this.handleFile(entry, zin, rootPath, resourceResolver);
            }
            zin.closeEntry();
        }
        zin.close();
    }

    private void handleDir(ZipEntry entry, String rootPath, ResourceResolver resourceResolver) throws PersistenceException {
        String filePath = rootPath + entry.getName();
        this.resourceUtil.getOrCreateResource(resourceResolver, filePath, "sling:Folder", "sling:Folder", true);
    }

    private void handleFile(ZipEntry entry, InputStream zin, String rootPath, ResourceResolver resourceResolver) throws RepositoryException, IOException {
        Value contentValue;
        String fileName = entry.getName();
        String filePath = rootPath + fileName;
        long size = entry.getSize();
        if (size > Integer.MAX_VALUE) {
            String message = String.format("File %s, exceeded the max size", fileName);
            log.error(message);
            return;
        }
        BoundedInputStream input = new BoundedInputStream(zin, size);
        Session s = resourceResolver.adaptTo(Session.class);
        ValueFactory valueFactory = s.getValueFactory();
        if (fileName.equals(INDEX_FILE_NAME)) {
            String contentWithBase = this.addBaseToIndexFile(input, rootPath);
            contentValue = valueFactory.createValue(contentWithBase);
        } else {
            Binary content = valueFactory.createBinary((InputStream)input);
            contentValue = valueFactory.createValue(content);
        }
        String mineType = this.mimeTypeService.getMimeType(Text.getName(fileName));
        this.createFileNode(filePath, contentValue, mineType, resourceResolver);
    }

    private void createFileNode(String filePath, Value content, String mimeType, ResourceResolver resourceResolver) throws PersistenceException, RepositoryException {
        Resource parentResource;
        int lastPos = filePath.lastIndexOf(47);
        String name = filePath.substring(lastPos + 1);
        if (lastPos == 0) {
            parentResource = resourceResolver.getResource("/");
        } else {
            String pe = filePath.substring(0, lastPos);
            parentResource = this.resourceUtil.getOrCreateResource(resourceResolver, pe, "sling:Folder", "sling:Folder", true);
        }
        Node parentNode = parentResource.adaptTo(Node.class);
        Node fileNode = parentNode.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}file");
        Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        contentNode.setProperty("jcr:mimeType", mimeType);
        contentNode.setProperty("jcr:data", content);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
    }

    private String addBaseToIndexFile(BoundedInputStream is, String rootPath) throws RepositoryException, IOException {
        String content = this.readStringContent(is);
        Pattern pattern = Pattern.compile("<html.*>");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            String base = String.format("<html>%s<base href=\"%s\">%s", System.lineSeparator(), rootPath, System.lineSeparator());
            String htmlOpenTag = matcher.group();
            return content.replaceFirst(htmlOpenTag, base);
        }
        return content;
    }

    private String readStringContent(BoundedInputStream is) throws IOException {
        int size = new BigDecimal(is.getSize()).intValueExact();
        StringBuffer content = new StringBuffer();
        int possition = 0;
        boolean keepReading = true;
        while (keepReading) {
            int byteArraySize = 0;
            byteArraySize = size > 0 ? size - possition : 512;
            byte[] byteContent = new byte[byteArraySize];
            int read = is.read(byteContent);
            possition += read;
            content.append(new String(byteContent, StandardCharsets.UTF_8.name()));
            if (read < 0) {
                keepReading = false;
                break;
            }
            if (size <= 0 || possition < size) continue;
            keepReading = false;
            break;
        }
        return content.toString();
    }

    static {
        log = LoggerFactory.getLogger(StaticContentZipUtils.class);
    }

    public static class ResourceUtilWrapper {
        private static ResourceUtilWrapper sharedInstance;

        public static ResourceUtilWrapper getSharedInstance() {
            if (null == sharedInstance) {
                sharedInstance = new ResourceUtilWrapper();
            }
            return sharedInstance;
        }

        public Resource getOrCreateResource(@Nonnull ResourceResolver resolver, @Nonnull String path, String resourceType, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
            return ResourceUtil.getOrCreateResource(resolver, path, resourceType, intermediateResourceType, autoCommit);
        }
    }
}

