/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.device.Device;
import com.adobe.cq.screens.device.DeviceManager;
import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.granite.haf.annotations.ApiAction;
import com.adobe.granite.haf.annotations.ApiEntities;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.ApiProperty;
import com.adobe.granite.haf.annotations.HttpFormParam;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/display"}, modelLookup=ScreensModelLookup.class)
public class ScreensDisplayModel {
    @Inject
    @Self
    protected Resource baseResource;
    @Inject
    @Named(value="jcr:content")
    protected Resource jcrContent;

    @ApiProperty
    public String getTitle() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:title", String.class));
    }

    @ApiProperty
    public String getDescription() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:description", String.class));
    }

    @ApiProperty
    public Integer getLayoutCols() {
        return ResourceUtil.getValueMap(this.jcrContent).get("layoutNumCols", 1);
    }

    @ApiProperty
    public Integer getLayoutRows() {
        return ResourceUtil.getValueMap(this.jcrContent).get("layoutNumRows", 1);
    }

    @ApiProperty
    public Integer getIdleTimeout() {
        Resource channels = this.jcrContent.getChild("channels");
        if (channels == null) {
            return 0;
        }
        return ResourceUtil.getValueMap(channels).get("idleTimeout", 0);
    }

    @ApiProperty
    public String getChannelTransition() {
        Resource channels = this.jcrContent.getChild("channels");
        return channels == null ? null : (String)((Object)ResourceUtil.getValueMap(channels).get("transition", String.class));
    }

    @ApiProperty
    public String getChannelOrchestrationStrategy() {
        Resource channels = this.jcrContent.getChild("channels");
        return channels == null ? null : (String)((Object)ResourceUtil.getValueMap(channels).get("strategy", String.class));
    }

    @ApiProperty
    public Integer getWidth() {
        Integer width = ResourceUtil.getValueMap(this.jcrContent).get("width", 0);
        if (width == 0) {
            width = Integer.parseInt(ResourceUtil.getValueMap(this.jcrContent).get("resolution", "0x0").split("x")[0]);
        }
        return width;
    }

    @ApiProperty
    public Integer getHeight() {
        Integer height = ResourceUtil.getValueMap(this.jcrContent).get("height", 0);
        if (height == 0) {
            height = Integer.parseInt(ResourceUtil.getValueMap(this.jcrContent).get("resolution", "0x0").split("x")[1]);
        }
        return height;
    }

    @ApiEntities
    public Iterable<Resource> children() {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Page page = this.baseResource.adaptTo(Page.class);
        if (page != null) {
            Iterator<Page> childPages = page.listChildren();
            while (childPages.hasNext()) {
                results.add(childPages.next().adaptTo(Resource.class));
            }
            Resource channels = page.getContentResource().getChild("channels");
            if (channels != null) {
                Iterator<Resource> channelAssignments = channels.listChildren();
                while (channelAssignments.hasNext()) {
                    results.add(channelAssignments.next());
                }
            }
        }
        return results;
    }

    @ApiAction(method="POST", name="broadcast-command")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload) throws RepositoryException, JSONException {
        this.executeCommand(msg, msgPayload, false);
    }

    @ApiAction(method="POST", name="broadcast-command-with-ack")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload, @HttpFormParam(value="requires_ack", optional=true) Boolean requiresAck) throws RepositoryException, JSONException {
        DeviceManager dm = this.baseResource.getResourceResolver().adaptTo(DeviceManager.class);
        if (dm == null) {
            return;
        }
        JSONObject payload = null;
        if (msgPayload != null) {
            payload = new JSONObject(msgPayload);
        }
        Iterator<Device> devices = dm.getRelatedDevices(this.baseResource);
        while (devices.hasNext()) {
            dm.executeCommand(devices.next(), msg, payload, requiresAck != null && requiresAck != false);
        }
    }
}

