/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.granite.haf.annotations.ApiEntities;
import com.adobe.granite.haf.annotations.ApiLink;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.ApiProperty;
import com.adobe.granite.haf.annotations.ApiRoot;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/root"}, modelLookup=ScreensModelLookup.class)
@ApiRoot(baseResource="/content/screens")
public class ScreensRootModel {
    @Inject
    @Self
    protected Resource baseResource;
    @ApiLink(rel="root")
    public String root = "/api/screens.json";
    @ApiLink(rel="devices")
    public String devices = "/api/screens-dcc/devices.json";
    @ApiLink(rel="registration")
    public String registration = "/api/screens-dcc/registration.json";

    @ApiProperty
    public String getTitle() {
        return (String)((Object)ResourceUtil.getValueMap(this.baseResource).get("jcr:title", String.class));
    }

    @ApiProperty
    public String getDescription() {
        return (String)((Object)ResourceUtil.getValueMap(this.baseResource).get("jcr:description", String.class));
    }

    @ApiEntities
    public Iterator<Resource> projects() {
        ArrayList<Resource> projects = new ArrayList<Resource>();
        for (Resource res : this.baseResource.getChildren()) {
            Resource jcrContent = res.getChild("jcr:content");
            if (jcrContent == null || !jcrContent.isResourceType("screens/core/components/project")) continue;
            projects.add(res);
        }
        return projects.iterator();
    }
}

