/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.activitystreams.listener.api;

import com.adobe.cq.social.activitystreams.api.SocialActivityManager;
import com.adobe.cq.social.activitystreams.impl.Activator;
import com.adobe.cq.social.activitystreams.listener.api.ActivityStreamProvider;
import com.adobe.cq.social.activitystreams.listener.api.ActivityStreamProviderExtension;
import com.adobe.cq.social.activitystreams.listener.api.EventListenerExtension;
import com.adobe.cq.social.activitystreams.listener.impl.ComparableStreamProviderExtension;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, label="%abstractactivitystreamprovider.name")
@References(value={@Reference(name="extensionProvider", referenceInterface=ActivityStreamProviderExtension.class, bind="bindExtension", unbind="unbindExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="listenerExtension", referenceInterface=EventListenerExtension.class, bind="bindListenerExtension", unbind="unbindListenerExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public abstract class AbstractActivityStreamProvider
implements ActivityStreamProvider {
    protected static final String UGC_WRITER = "ugc-writer";
    protected static final String SLING_SERVICE_SUBSERVICE = "sling.service.subservice";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractActivityStreamProvider.class);
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected SocialActivityManager activityManager;
    @Reference
    protected final SlingRepository repository = null;
    String servicePid;
    private volatile ComponentContext context;
    private final List<ActivityStreamProviderExtension> boundExtensions = new LinkedList<ActivityStreamProviderExtension>();
    private final CopyOnWriteArrayList<ComparableStreamProviderExtension> extensions = new CopyOnWriteArrayList();
    private ServiceUserWrapper serviceUserWrapper;
    private ResourceResolverFactory privateResourceResolverFactory;

    public ServiceUserWrapper getServiceUserWrapper() {
        if (this.serviceUserWrapper == null) {
            this.serviceUserWrapper = (ServiceUserWrapper)Activator.getService(ServiceUserWrapper.class);
        }
        return this.serviceUserWrapper;
    }

    public ResourceResolverFactory getPrivateResourceResolverFactory() {
        if (this.privateResourceResolverFactory == null) {
            this.privateResourceResolverFactory = (ResourceResolverFactory)Activator.getService(ResourceResolverFactory.class);
        }
        return this.privateResourceResolverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Activity activity) throws ActivityException {
        if (this.activityManager == null) {
            return;
        }
        ResourceResolver ugcResolver = null;
        try {
            ugcResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getPrivateResourceResolverFactory(), Collections.singletonMap(SLING_SERVICE_SUBSERVICE, UGC_WRITER));
            ActivityStream stream = this.getStream(activity, ugcResolver);
            if (stream != null) {
                stream.append(activity);
            }
        }
        catch (LoginException le) {
            LOGGER.error("Can't obtain resolver for service user", le);
            return;
        }
        finally {
            if (ugcResolver != null && ugcResolver.isLive()) {
                ugcResolver.close();
            }
        }
    }

    protected abstract ActivityStream getStream(Activity var1, ResourceResolver var2) throws ActivityException;

    protected abstract Session getAdminSession() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) throws LoginException {
        ArrayList<ActivityStreamProviderExtension> extensionsCopy;
        LOGGER.debug("Activating " + this.getClass().getName());
        this.servicePid = (String)ctx.getProperties().get("service.pid");
        this.context = ctx;
        List<ActivityStreamProviderExtension> list = this.boundExtensions;
        synchronized (list) {
            extensionsCopy = new ArrayList<ActivityStreamProviderExtension>(this.boundExtensions);
            this.boundExtensions.clear();
        }
        for (ActivityStreamProviderExtension extension : extensionsCopy) {
            this.addExtension(extension);
        }
    }

    protected void deactivate(ComponentContext context) {
        LOGGER.debug("Deactivating " + this.getClass().getName());
        this.activityManager = null;
        this.context = null;
    }

    protected ResourceResolver getServiceResourceResolver(Session session) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindExtension(ActivityStreamProviderExtension extension) {
        LOGGER.debug("Binding : {} activated: {}", (Object)extension.getName(), (Object)(this.context == null ? 1 : 0));
        if (this.context == null) {
            List<ActivityStreamProviderExtension> list = this.boundExtensions;
            synchronized (list) {
                if (this.context == null) {
                    this.boundExtensions.add(extension);
                } else {
                    this.addExtension(extension);
                }
            }
        } else {
            this.addExtension(extension);
        }
    }

    private synchronized void addExtension(ActivityStreamProviderExtension extension) {
        if (!this.hasExtension(extension) && this.validateExtension(extension)) {
            int ranking = extension.getRanking();
            ComparableStreamProviderExtension cextension = new ComparableStreamProviderExtension(extension, ranking);
            int index = Collections.binarySearch(this.extensions, cextension);
            int insertAt = index < 0 ? -(index + 1) : index + 1;
            this.extensions.add(insertAt, cextension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindListenerExtension(EventListenerExtension extension) {
        LOGGER.debug("Binding : {} activated:{}", (Object)extension.getName(), (Object)(this.context == null ? 1 : 0));
        if (this.context == null) {
            List<ActivityStreamProviderExtension> list = this.boundExtensions;
            synchronized (list) {
                if (this.context == null) {
                    this.boundExtensions.add(new ActivityStreamProviderExtensionWrapper(extension));
                } else {
                    this.addExtension(new ActivityStreamProviderExtensionWrapper(extension));
                }
            }
        } else {
            this.addExtension(new ActivityStreamProviderExtensionWrapper(extension));
        }
    }

    public void unbindListenerExtension(EventListenerExtension extension) {
        LOGGER.debug("Unbinding {} activated:{}", (Object)extension.getName(), (Object)(this.context == null ? 1 : 0));
        this.unbindExtension(extension.getName());
    }

    private boolean validateExtension(ActivityStreamProviderExtension extension) {
        String[] streams = extension.getStreamProviderPid();
        if (streams.length == 1 && StringUtils.equals(streams[0], "*")) {
            return true;
        }
        for (String name : streams) {
            if (!StringUtils.equals(name, this.servicePid)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtension(ActivityStreamProviderExtension extension) {
        for (ActivityStreamProviderExtension activityStreamProviderExtension : this.extensions) {
            if (!extension.getName().equals(activityStreamProviderExtension.getName())) continue;
            return true;
        }
        return false;
    }

    public void unbindExtension(ActivityStreamProviderExtension extension) {
        LOGGER.debug("Unbind extension {} activated {}", (Object)extension.getName(), (Object)(this.context == null ? 1 : 0));
        this.unbindExtension(extension.getName());
    }

    private synchronized void unbindExtension(String name) {
        int index = 0;
        for (ActivityStreamProviderExtension activityStreamProviderExtension : this.extensions) {
            if (activityStreamProviderExtension.getName().equals(name)) {
                this.extensions.remove(index);
                break;
            }
            ++index;
        }
    }

    @Override
    public List<ActivityStreamProviderExtension> getExtensions() {
        return new CopyOnWriteArrayList<ComparableStreamProviderExtension>(this.extensions);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindActivityManager(SocialActivityManager socialActivityManager) {
        this.activityManager = socialActivityManager;
    }

    protected void unbindActivityManager(SocialActivityManager socialActivityManager) {
        if (this.activityManager == socialActivityManager) {
            this.activityManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected class ActivityStreamProviderExtensionWrapper
    implements ActivityStreamProviderExtension {
        private EventListenerExtension eventListenerExtension;
        private final String[] STREAM_PROVIDER_PID = new String[]{"*"};

        public ActivityStreamProviderExtensionWrapper(EventListenerExtension eventListenerExtension) {
            this.eventListenerExtension = eventListenerExtension;
        }

        @Override
        public String getName() {
            return this.eventListenerExtension.getName();
        }

        @Override
        public String[] getStreamProviderPid() {
            return this.STREAM_PROVIDER_PID;
        }

        @Override
        public boolean evaluate(SocialEvent<?> event, Resource resource) {
            return this.eventListenerExtension.evaluate(event, resource);
        }

        @Override
        public int getRanking() {
            return this.eventListenerExtension.getRanking();
        }

        @Override
        public Map<String, ? extends Object> getActivityProperties(SocialEvent<?> event, Resource resource) {
            return this.eventListenerExtension.getActivityProperties(event, resource);
        }

        @Override
        public Map<String, ? extends Object> getObjectProperties(SocialEvent<?> event, Resource resource) {
            return this.eventListenerExtension.getObjectProperties(event, resource);
        }

        @Override
        public Map<String, ? extends Object> getActorProperties(SocialEvent<?> event, Resource resource) {
            return this.eventListenerExtension.getActorProperties(event, resource);
        }

        @Override
        public Map<String, ? extends Object> getTargetProperties(SocialEvent<?> event, Resource resource) {
            return this.eventListenerExtension.getTargetProperties(event, resource);
        }
    }
}

