/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.FileUploadSizeLimit;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.endpoints.UploadOperationUtils;
import com.adobe.cq.social.commons.comments.scheduler.api.ScheduledPostService;
import com.adobe.cq.social.commons.comments.states.internal.State;
import com.adobe.cq.social.commons.comments.states.internal.StateMachine;
import com.adobe.cq.social.commons.ugclimiter.api.UGCLimiterService;
import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.scf.InheritedOperationExtensionManager;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.cq.social.ugcbase.core.attachments.AttachmentUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.Relationship;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.date.DateUtil;
import com.day.cq.commons.date.InvalidDateException;
import com.day.text.Text;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@Property(name="fieldWhitelist", value={"cq:tags", "tags", "composedFor"}, cardinality=100), @Property(name="attachmentTypeBlacklist", cardinality=0x7FFFFFFF, value={"DEFAULT"})})
public abstract class AbstractCommentOperationService<T extends OperationExtension, U extends Operation, S extends com.adobe.cq.social.commons.comments.api.Comment>
extends AbstractOperationService<T, U, S> {
    private static final String CQ_TAGS_PROPERTY = "cq:tags";
    public static final String CHARSET_PROPERTY = "_charset_";
    public static final String TAGS_PROPERTY = "tags";
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    private static final String MODERATORS_ROLE = "moderators";
    private static final String OWNER_ROLE = "owner";
    private static final String PROPERTY_STATE = "state_s";
    private static final String PROPERTY_TOSTATE = "toState";
    private static final String PROPERTY_ISCREATEDBYPRIVUSER = "isCreatedByPrivilegedUser";
    private static final String PROPERTY_STATE_OPERATION = "stateOperation";
    private static final String PROPERTY_ADD_REPLY = "addReply";
    private static final String DRAFT_STATE = "Draft";
    private static final String SUBMITTED_STATE = "Submitted";
    private static final String ANONYMOUS = "anonymous";
    private static final String IGNORE_EVENT_POST = "ignoreEventPost";
    private static final String UGC_MENTIONED_USER_PLACEHOLDER_TAG_START = "<social-mention>";
    private static final String UGC_MENTIONED_USER_PLACEHOLDER_TAG_END = "</social-mention>";
    private static final String NOTIFICATION = "notification";
    private static final String SUBSCRIPTION = "subscription";
    private static final String ACTIVITYSTREAMS = "following";
    private static final String PN_ALLOW_ALL_MEMBERS = "allowAllMembers";
    private static final Pattern ANCHOR_MENTION_SOCIAL_AUTHORIZABLE_PATTERN = Pattern.compile("(<a [^<>]*?data-social-mention-authorizableid=\")(.+?)(\"[^<>]*?>)(.+?)(</a>)");
    private static final boolean PV_DEFAULT_ALLOW_ALL_MEMBERS = false;
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"email", "userIdentifier", "url"};
    public static final String PROPERTY_ATTACHMENT_TYPE_BLACKLIST = "attachmentTypeBlacklist";
    public static final String PROP_MESSAGE = "message";
    private static final String PN_COMPOSED_FOR = "composedFor";
    private static final String PARAM_IS_MESSAGE_ENCODED = "messageEncoded";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentOperationService.class);
    private static final String PROP_ATT_TO_REMOVE = "attToRemove";
    public static final String PROP_CONTEXT_PATH = "contextPath";
    @Reference
    public SocialComponentFactoryManager componentFactoryManager;
    @Reference
    protected ScheduledPostService futurePostScheduler;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected Externalizer externalizer;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    protected EventAdmin eventAdmin;
    @Reference
    protected UGCLimiterService ugcLimiterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference
    protected InheritedOperationExtensionManager extensionManager;
    protected String[] fieldWhitelist;
    protected String[] attachmentTypeBlacklist;
    private ComponentContext context;
    @Reference
    ServiceUserWrapper serviceUserWrapper;
    private static AtomicBoolean userManagerCompatibilityMessageLogged = new AtomicBoolean(false);

    @Override
    public InheritedOperationExtensionManager getInheritedOperationExtensionManager() {
        return this.extensionManager;
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
        String ugcUrl;
        String isPublishLater;
        String isDraft;
        String value;
        String authId;
        Resource resource = request.getResource();
        String name = this.getAuthorizableId(request, session);
        CommentSystem cs = this.getCommentSystem(resource, session);
        CommentCollectionConfiguration commentCollectionConfiguration = this.getCommentCollectionConfiguration(resource, session);
        Comment comment = this.getComment(resource, session);
        Boolean isCreatedByPrivilegedUser = CommentUtil.isUserPrivileged(cs.getResource(), resource.getResourceResolver(), name);
        props.put(PROPERTY_ISCREATEDBYPRIVUSER, isCreatedByPrivilegedUser);
        props.put(PROP_CONTEXT_PATH, request.getContextPath());
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        props.put("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        props.put("url", website);
        props.put("ip", this.getClientIpAddr(request));
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank(userAgent)) {
            props.put("userAgent", request.getHeader("User-Agent"));
        }
        if (StringUtils.isNotBlank(authId = this.getAuthorizableId(request, session))) {
            props.put("authorizableId", authId);
        }
        this.getReferrerProperty(request, props);
        String isMsgEncoded = request.getParameter(PARAM_IS_MESSAGE_ENCODED);
        if (StringUtils.isNotBlank(isMsgEncoded)) {
            props.put(PARAM_IS_MESSAGE_ENCODED, Boolean.parseBoolean(isMsgEncoded));
        }
        if (StringUtils.isNotBlank(value = request.getParameter(PROP_MESSAGE))) {
            MentionsData mentionsData = this.socialMentionUgcConvertor(commentCollectionConfiguration, value);
            if (mentionsData.mentionedUsers != null && mentionsData.mentionedUsers.size() > 0) {
                props.put("mentions", mentionsData.mentionedUsers.toArray());
            }
            props.put(PROP_MESSAGE, value);
        }
        if (StringUtils.isNotBlank(isDraft = request.getParameter("isDraft"))) {
            props.put("isDraft", Boolean.parseBoolean(isDraft));
            props.put(PROPERTY_STATE, Boolean.parseBoolean(isDraft) ? DRAFT_STATE : SUBMITTED_STATE);
        }
        if (StringUtils.isNotBlank(isPublishLater = request.getParameter("isScheduled"))) {
            String publishDateString = request.getParameter("publishDate");
            if (StringUtils.isNotBlank(publishDateString)) {
                try {
                    Calendar publishDate = DateUtil.parseISO8601(publishDateString, TimeZone.getTimeZone("Etc/UTC"));
                    if (publishDate == null) {
                        throw new OperationException("Publish date and time format is incorrect", 400);
                    }
                    props.put("publishDate", publishDate);
                }
                catch (InvalidDateException e) {
                    LOG.error("Invalid date format for publishDate %s while trying to create/update comment", (Object)publishDateString);
                    throw new OperationException("Publish date and time format is incorrect", 400);
                }
                props.put("isScheduled", Boolean.parseBoolean(isPublishLater));
            } else {
                throw new OperationException("Publish date is empty", 400);
            }
        }
        if (StringUtils.isNotBlank(ugcUrl = request.getParameter("ugcUrl"))) {
            props.put("ugcUrl", ugcUrl);
        }
    }

    private MentionsData socialMentionUgcConvertor(CommentCollectionConfiguration commentCollectionConfiguration, String message) throws OperationException {
        HashSet<String> mentionedUsers = new HashSet<String>();
        String ugcMessage = message;
        if (commentCollectionConfiguration.isMentionsEnabled()) {
            StringBuffer socialMentionUgcConvertedData = new StringBuffer();
            Matcher mentionSocialAuthorizableMatcher = ANCHOR_MENTION_SOCIAL_AUTHORIZABLE_PATTERN.matcher(message);
            while (mentionSocialAuthorizableMatcher.find()) {
                String ugcMentionedUserData = UGC_MENTIONED_USER_PLACEHOLDER_TAG_START + mentionSocialAuthorizableMatcher.group(2) + UGC_MENTIONED_USER_PLACEHOLDER_TAG_END;
                mentionedUsers.add(mentionSocialAuthorizableMatcher.group(2));
                mentionSocialAuthorizableMatcher.appendReplacement(socialMentionUgcConvertedData, ugcMentionedUserData);
            }
            mentionSocialAuthorizableMatcher.appendTail(socialMentionUgcConvertedData);
            if (commentCollectionConfiguration.isMentionsEnabled() && mentionedUsers.size() > commentCollectionConfiguration.getMaxMentions()) {
                throw new OperationException("Too many mentions", 500);
            }
            ugcMessage = socialMentionUgcConvertedData.toString();
        }
        MentionsData mentionsData = new MentionsData(mentionedUsers, ugcMessage);
        return mentionsData;
    }

    private void getReferrerProperty(SlingHttpServletRequest request, Map<String, Object> props) throws RepositoryException {
        String referrerUrl = this.getReferrer(request);
        if (StringUtils.isNotBlank(referrerUrl)) {
            props.put("referer", referrerUrl);
            try {
                URL url = new URL(referrerUrl);
                props.put("Referer", url.getFile());
            }
            catch (MalformedURLException e) {
                if (referrerUrl.matches("^https?:")) {
                    LOG.error("Error parsing referer url", e);
                }
                if (StringUtils.startsWith(referrerUrl, "/")) {
                    LOG.info("Referrer URL does not have a protocol, returning passed in value {}", (Object)referrerUrl);
                    props.put("Referer", referrerUrl);
                }
                LOG.error("Error parsing referer url", e);
            }
        }
    }

    private String getClientIpAddr(SlingHttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private void addProp(Map<String, Object> props, String name, SlingHttpServletRequest request, Session session) throws RepositoryException {
        String value = request.getParameter(name);
        if (StringUtils.isNotBlank(value)) {
            props.put(name, value);
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> map, Session session) throws RepositoryException {
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (map.containsKey(key) || StringUtils.equals(key, CHARSET_PROPERTY)) continue;
            if (!ArrayUtils.contains(this.fieldWhitelist, key) || key.contains(":")) {
                LOG.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            if (!ArrayUtils.contains(RESERVED_PROPERTY_NAMES, key)) {
                RequestParameter[] values = (RequestParameter[])params.get(key);
                if (values.length > 0 && values[0].isFormField()) {
                    Object value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                    if (null == value) continue;
                    if (key.equals("userIdentifier") && ((String)value).length() == 0) {
                        LOG.debug("skipped custom form field \"userIdentifier\", empty value is not allowed.");
                        continue;
                    }
                    map.put(key, value);
                    continue;
                }
                LOG.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
                continue;
            }
            LOG.debug("skipped custom form field [{}], matches reserved field name.", (Object)key);
        }
    }

    protected List<DataSource> filterAttachments(List<DataSource> attachments, CommentSystem cs) {
        if (BooleanUtils.toBoolean(cs.allowsAttachment())) {
            List<DataSource> attList = attachments;
            HashSet<String> whitelist = cs.getAllowedFileTypes() == null ? null : new HashSet<String>(cs.getAllowedFileTypes());
            Iterable<DataSource> filtered = AttachmentUtils.getAttachmentsFromDataSources(attList, new FileUploadSizeLimit(cs.getAttachmentSizeLimit(), cs.getAttachmentSizeLimit()), whitelist, this.attachmentTypeBlacklist);
            List filteredAttList = IteratorUtils.toList(filtered.iterator());
            return new ArrayList<DataSource>(filteredAttList);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, CommentSystem cs) {
        if (BooleanUtils.toBoolean(cs.allowsAttachment())) {
            RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, cs.getAttachmentSizeLimit(), cs.getAllowedFileTypes(), this.attachmentTypeBlacklist);
        }
        return Collections.emptyList();
    }

    public void removeAttachment(Resource attachment, ResourceResolver serviceUserResolver) {
        if (attachment != null) {
            Resource commentResource;
            Comment comment;
            Resource target = attachment;
            SocialUtils socialUtils = attachment.getResourceResolver().adaptTo(SocialUtils.class);
            if (!socialUtils.hasModeratePermissions(attachment) || !socialUtils.hasModeratePermissions(attachment.getParent())) {
                target = serviceUserResolver.getResource(attachment.getPath());
            }
            if ((comment = (commentResource = target.getParent()).adaptTo(Comment.class)) != null) {
                comment.removeAttachment(attachment.getName());
            }
        }
    }

    protected boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected boolean isBot(SlingHttpServletRequest request) {
        String botCheck = request.getParameter("id");
        return botCheck == null || !botCheck.equals("nobot");
    }

    protected ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    protected CommentSystem getCommentSystem(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", e);
            return null;
        }
        if (null != res && !(res instanceof NonExistingResource)) {
            return res.adaptTo(CommentSystem.class);
        }
        return null;
    }

    protected CommentCollectionConfiguration getCommentCollectionConfiguration(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve((String)r.getValueMap().get("social:rootCommentSystem"));
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", e);
            return null;
        }
        if (res.getPath().equals("/")) {
            return new AbstractCommentCollectionConfiguration(r.getValueMap());
        }
        return new AbstractCommentCollectionConfiguration(res.getValueMap());
    }

    protected Comment getComment(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", e);
            return null;
        }
        if (null != res) {
            return res.adaptTo(Comment.class);
        }
        return null;
    }

    protected String getAuthorizableId(SlingHttpServletRequest request, Session session) throws OperationException {
        String userIdentifier = request.getParameter("userIdentifier");
        if (StringUtils.isBlank(userIdentifier)) {
            userIdentifier = this.getUserIdFromRequest(request, "Anonymous");
        }
        String sessionUserId = this.getUserIdFromRequest(request, null);
        String id = "";
        if (StringUtils.isNotBlank(sessionUserId)) {
            boolean anonymous = "Anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, this.getRequestSession(request));
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), session);
                if (userExists && hasPermissions) {
                    id = userIdentifier;
                    if (!userIdentifier.equals(sessionUserId)) {
                        LOG.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", request.getRemoteAddr(), userIdentifier, sessionUserId);
                    }
                } else {
                    LOG.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(exceptionMessage);
                    }
                    throw new OperationException(exceptionMessage, 404);
                }
                id = userId;
            } else {
                id = ANONYMOUS;
            }
        }
        return id;
    }

    protected String getUserIdFromRequest(SlingHttpServletRequest request, String defaultValue) {
        String userIdentifier;
        UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
        String string = userIdentifier = up == null ? null : up.getAuthorizableID();
        if (userIdentifier == null) {
            userIdentifier = defaultValue;
        }
        return userIdentifier;
    }

    protected UserProperties getSessionUserProperties(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(UserProperties.class);
    }

    protected Session getRequestSession(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(Session.class);
    }

    protected boolean userExists(String userId, Session session) {
        try {
            ResourceResolver resourceResolver = this.getResourceResolver(session);
            UserManager userManager = resourceResolver.adaptTo(UserManager.class);
            Authorizable user = userManager.getAuthorizable(userId);
            if (user != null) {
                return true;
            }
        }
        catch (RepositoryException e) {
            LOG.debug("Error checking for user existence", e);
        }
        catch (LoginException e) {
            LOG.debug("Error checking for user existence", e);
        }
        return false;
    }

    protected boolean isUserPrivileged(CommentSystem cs, Session session, String userId) {
        ResourceResolver resolver = null;
        try {
            resolver = this.getResourceResolver(session);
        }
        catch (LoginException e) {
            LOG.debug("Could not check for user privileges", e);
        }
        Boolean isUserPrivileged = CommentUtil.isUserPrivileged(cs.getResource(), resolver, userId);
        if (!isUserPrivileged.booleanValue() && CommentUtil.getProperty(cs.getResource(), PN_ALLOW_ALL_MEMBERS, false).booleanValue()) {
            return true;
        }
        return isUserPrivileged;
    }

    protected boolean hasPermissions(String userIdentifier, Session requestSession, Session adminSession) {
        try {
            if (StringUtils.isNotBlank(userIdentifier)) {
                UserProperties userProperties = this.getResourceResolver(requestSession).adaptTo(UserProperties.class);
                if (requestSession != null) {
                    return requestSession.hasPermission(userProperties.getResource(".").getPath(), "read");
                }
            }
            return false;
        }
        catch (LoginException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.attachmentTypeBlacklist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_ATTACHMENT_TYPE_BLACKLIST));
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    protected Resource getResource(String path, Session session) {
        try {
            return this.getResourceResolver(session).getResource(path);
        }
        catch (LoginException e) {
            LOG.error("Error getching the resource resolver from session", e);
            return null;
        }
    }

    protected void postEvent(SocialEvent event) {
        EventAdmin localEventAdminRef = this.eventAdmin;
        if (null != localEventAdminRef) {
            localEventAdminRef.postEvent(event);
        }
    }

    protected Resource create(Resource targetCommentSystemResource, CommentSystem cs, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        Iterator<String> v;
        boolean rootPathExists;
        String message;
        U createOperation = this.getCreateOperation();
        this.performBeforeActions(createOperation, session, targetCommentSystemResource, props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
        }
        if (cs.isClosed()) {
            throw new OperationException("Reply attempted on closed comment system: " + cs.getPath(), 405);
        }
        try {
            message = this.getStringProperty(PROP_MESSAGE, props);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get the new message value", e, 500);
        }
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
        if (parent != null && parent.isClosed()) {
            throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
        }
        if (parent != null && !this.mayReply(targetCommentSystemResource, cs)) {
            throw new OperationException("Reply is not allowed: " + targetCommentSystemResource.getPath(), 403);
        }
        long messageCharacterLimit = cs.getMessageCharacterLimit();
        String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
        if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
            throw new OperationException("Parameter message exceeded character limit", 400);
        }
        boolean bl = rootPathExists = this.getResource(cs.getRootPath(), session) != null;
        if (props.containsKey(PROP_MESSAGE)) {
            props.put("jcr:description", props.get(PROP_MESSAGE));
            props.remove(PROP_MESSAGE);
        }
        if (props.containsKey(TAGS_PROPERTY)) {
            props.put(CQ_TAGS_PROPERTY, props.get(TAGS_PROPERTY));
            props.remove(TAGS_PROPERTY);
        }
        if (props.containsKey("publishDate") && props.get("publishDate") instanceof Calendar) {
            Calendar d = Calendar.getInstance();
            d.setTime(((Calendar)props.get("publishDate")).getTime());
            props.put("publishDate", d);
        }
        if (props.containsKey(CQ_TAGS_PROPERTY) && !((v = props.get(CQ_TAGS_PROPERTY)) instanceof String[])) {
            if (v instanceof String) {
                if (String.valueOf(v).isEmpty()) {
                    props.remove(CQ_TAGS_PROPERTY);
                } else {
                    props.put(CQ_TAGS_PROPERTY, new String[]{(String)((Object)v)});
                }
            } else {
                throw new OperationException("Parameter cq:tags is not a String Array", 400);
            }
        }
        for (String key : props.keySet()) {
            if (!StringUtils.startsWith(key, "scf:")) continue;
            props.remove(key);
        }
        if (!props.containsKey("added") || !(props.get("added") instanceof Calendar) && !(props.get("added") instanceof Date)) {
            Calendar cal = Calendar.getInstance();
            props.put("added", cal);
        }
        message = this.encodeMessageIfNeeded(message, props, cs.isRteEnabled());
        try {
            ModifiableValueMap vm;
            Comment comment = cs.addComment(message, author, attachments, "", this.getResourceType(targetCommentSystemResource), props);
            if (SocialResourceUtils.isSocialResource(comment.getResource()) && (vm = comment.getResource().adaptTo(ModifiableValueMap.class)) != null) {
                String entityUrl = this.getEntityUrl(comment.getResource());
                if (!StringUtils.isEmpty(entityUrl)) {
                    vm.put("social:entity", entityUrl);
                }
                if (!cs.isModerated()) {
                    vm.put("approved", true);
                }
                vm.put("eventTopic", this.getEventTopic());
                if (vm.get("publishDate", Calendar.class) == null && !vm.get("isDraft", false).booleanValue()) {
                    vm.put("publishDate", Calendar.getInstance());
                }
            }
            String userId = author;
            if (props.containsKey(PN_COMPOSED_FOR)) {
                userId = comment.getProperty(PN_COMPOSED_FOR, author);
            }
            boolean throwEvent = true;
            if (comment.getProperty("isDraft", false).booleanValue()) {
                Calendar publishDate;
                throwEvent = false;
                if (comment.getProperty("publishDate", Calendar.class) != null && (publishDate = (Calendar)((Object)comment.getProperty("publishDate", Calendar.class))).compareTo(Calendar.getInstance()) <= 0) {
                    ModifiableValueMap vm2 = comment.getResource().adaptTo(ModifiableValueMap.class);
                    vm2.put("isDraft", false);
                    vm2.put("cq:lastModified", publishDate);
                    vm2.put("added", publishDate.getTime());
                    throwEvent = true;
                }
            } else if (cs.isModerated()) {
                throwEvent = false;
            }
            cs.save();
            LOG.info("Comment created: " + comment.getPath());
            S commentComp = this.getSocialComponentForResource(comment.getResource());
            this.performAfterActions(createOperation, session, commentComp, props);
            if (throwEvent) {
                this.postCreateEvent(commentComp, userId);
            }
            return comment.getResource();
        }
        catch (CommentException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create comment.", e, 500);
        }
    }

    private String encodeMessageIfNeeded(String msg, Map<String, Object> props, boolean isRTEEnabled) {
        boolean msgNeedsEncoding;
        String message = msg;
        boolean bl = msgNeedsEncoding = !isRTEEnabled;
        if (props.containsKey(PARAM_IS_MESSAGE_ENCODED)) {
            boolean isMsgEncoded = (Boolean)props.get(PARAM_IS_MESSAGE_ENCODED);
            msgNeedsEncoding = !isMsgEncoded;
            props.remove(PARAM_IS_MESSAGE_ENCODED);
        }
        if (msgNeedsEncoding) {
            message = StringEscapeUtils.escapeHtml4(message);
        }
        return message;
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", e);
        }
    }

    public Resource create(Resource root, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(root, session);
        List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
        return this.create(root, cs, author, props, filteredAttachments, session);
    }

    public Resource create(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        this.validateParameters(request);
        if (cs == null) {
            throw new OperationException("Post at " + resource.getPath() + " is not available", 404);
        }
        String name = this.getAuthorizableId(request, session);
        if (name.equals(ANONYMOUS)) {
            throw new OperationException("Session is invalid", 401);
        }
        if (this.ugcLimiterService == null) {
            this.ugcLimiterService = Activator.getService(UGCLimiterService.class);
        }
        if (!this.ugcLimiterService.mayCreateUGC(request.getResourceResolver(), name)) {
            throw new OperationException("Exceeded contribution limit of " + this.ugcLimiterService.getUgcLimit() + " pieces of content per " + this.getDurationString(this.ugcLimiterService.getUgcDuration()) + ". " + this.getUGCLimitModerators(this.ugcLimiterService.getUgcLimitedToList()), 403);
        }
        if (!this.mayPost(request, cs, name)) {
            throw new OperationException("User not allowed to post to forum at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException("Failed to create comment", e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        boolean isUserPrivileged = CommentUtil.isUserPrivileged(cs.getResource(), request.getResourceResolver(), name);
        if (!isUserPrivileged) {
            try {
                String isComposedForUserExist = this.getStringProperty(PN_COMPOSED_FOR, props);
                if (isComposedForUserExist != null) {
                    throw new OperationException("Failed to create comment on behalf of other user", 500);
                }
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to get the new composedFor property value", e, 500);
            }
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        return this.create(resource, cs, name, props, attachments, session);
    }

    public Resource uploadImage(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        String name = this.getAuthorizableId(request, session);
        if (name.equals(ANONYMOUS)) {
            throw new OperationException("Session is invalid", 401);
        }
        CommentSystem cs = this.getCommentSystem(resource, session);
        if (!this.mayPost(request, cs, name)) {
            throw new OperationException("User not allowed to post to comment at " + cs.getPath(), 412);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            LOG.error("Failed to get request properties at " + resource.getPath(), e);
            throw new OperationException("Failed to get request properties", e, 203);
        }
        catch (RepositoryException e) {
            LOG.error("Failed to get request properties @ " + resource.getPath(), e);
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        return this.uploadImageToTemp(resource, cs, name, attachments, session);
    }

    public Resource uploadImageToTemp(Resource targetCommentSystemResource, CommentSystem cs, String author, List<DataSource> attachments, Session session) throws OperationException {
        block8: {
            if (cs == null) {
                throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
            }
            List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
            Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
            if (parent != null && parent.isClosed()) {
                throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
            }
            if (attachments.size() == 0) {
                LOG.debug("Invalid attachment because of invalid type or size");
                throw new OperationException("Unsupported attachment", 500);
            }
            if (attachments.size() == 1) {
                DataSource data = attachments.get(0);
                try {
                    Node uploadRoot = UploadOperationUtils.createOrGetUploadResource(session, targetCommentSystemResource.getPath());
                    if (attachments.size() == 1) {
                        String name = RandomStringUtils.random(5, true, false) + "-" + Text.getName(data.getName());
                        Node attachment = UploadOperationUtils.addAttachment(uploadRoot, name, data.getInputStream(), data.getContentType());
                        session.save();
                        return targetCommentSystemResource.getResourceResolver().getResource(attachment.getPath());
                    }
                    break block8;
                }
                catch (RepositoryException e) {
                    throw new OperationException("Could not upload image", e, 500);
                }
                catch (IOException e) {
                    throw new OperationException("Could not upload image", e, 500);
                }
            }
            LOG.debug("Invalid number of attachments " + attachments.size());
            throw new OperationException("Invalid number of attachment", 500);
        }
        return null;
    }

    public Resource uploadImage(Resource targetCommentSystemResource, CommentSystem cs, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        if (cs == null) {
            LOG.error("Failed to get comment system for target " + targetCommentSystemResource.getPath());
            throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
        }
        U uploadImageOperation = this.getUploadImageOperation();
        if (uploadImageOperation != null) {
            Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
            this.performBeforeActions(uploadImageOperation, session, parent.getResource(), props);
            List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
            if (parent != null && parent.isClosed()) {
                LOG.error("Reply attempted on closed comment: " + targetCommentSystemResource.getPath());
                throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
            }
            if (parent != null && !this.mayReply(targetCommentSystemResource, cs)) {
                LOG.error("Reply is not allowed: " + targetCommentSystemResource.getPath());
                throw new OperationException("Reply is not allowed: " + targetCommentSystemResource.getPath(), 403);
            }
            if (attachments.size() == 1) {
                DataSource data = attachments.get(0);
                try {
                    Resource image = parent.addImage(data.getName(), data.getInputStream(), data.getContentType());
                    this.performAfterActions(uploadImageOperation, session, this.getSocialComponentForResource(targetCommentSystemResource), props);
                    image.getResourceResolver().commit();
                    return image;
                }
                catch (IOException e) {
                    LOG.error("IOException while trying to add image at " + targetCommentSystemResource.getPath());
                    throw new OperationException("IOException while trying to add image", e, 500);
                }
            }
            LOG.error("Only one attachment supported " + targetCommentSystemResource.getPath());
            throw new OperationException("Invalid number of attachment", 500);
        }
        throw new OperationException("Unsupported operation", 400);
    }

    private String getStringProperty(String key, Map<String, Object> props) throws RepositoryException {
        Object obj = props.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            return ((Value)obj).getString();
        }
        return obj.toString();
    }

    protected void validateParameters(SlingHttpServletRequest request) throws OperationException {
        String message = request.getParameter(PROP_MESSAGE);
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        if (this.isBot(request)) {
            throw new OperationException("Bot check failed: Parameter id is missing or has unexpected value", 412);
        }
    }

    protected boolean mayPost(SlingHttpServletRequest request, CommentSystem cs, String userId) {
        ResourceResolver resolver = request.getResourceResolver();
        if (null != resolver && null != cs) {
            if (userId.equals(ANONYMOUS)) {
                return false;
            }
            ResourceResolver ugcWriterResovler = cs.getResource().getResourceResolver();
            Resource r = ugcWriterResovler.getResource(cs.getPath());
            SocialUtils socialUtils = ugcWriterResovler.adaptTo(SocialUtils.class);
            if (null != r && null != socialUtils) {
                r = ugcWriterResovler.getResource(socialUtils.resourceToACLPath(r));
            }
            if (null == r) {
                r = resolver.getResource("/content/usergenerated");
            }
            if (r != null) {
                return CollabUtil.canAddNode(resolver.adaptTo(Session.class), r.getPath());
            }
        }
        return false;
    }

    protected boolean mayEdit(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        boolean mayEdit;
        boolean bl = mayEdit = CollabUtil.hasModeratePermissions(request.getResource()) || CollabUtil.isResourceOwner(request.getResource());
        if (mayEdit) {
            return true;
        }
        ValueMap props = request.getResource().adaptTo(ValueMap.class);
        String composedBy = props.get("composedBy", "");
        return mayEdit || StringUtils.equals(userId, composedBy);
    }

    protected boolean mayReply(Resource root, CommentSystem cs) throws OperationException {
        return cs.allowsReplies();
    }

    protected boolean mayDelete(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        return this.mayEdit(request, cs, userId);
    }

    protected String getAuthorFromRequest(SlingHttpServletRequest request) {
        String name = request.getParameter("userIdentifier");
        if (StringUtils.isBlank(name)) {
            UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
            String string = name = up == null ? null : up.getAuthorizableID();
            if (name == null) {
                name = "Anonymous";
            }
        }
        return name;
    }

    public Resource update(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        this.validateParameters(request);
        String userId = this.getAuthorizableId(request, session);
        if (userId.equals(ANONYMOUS)) {
            throw new OperationException("Session is invalid", 401);
        }
        if (!this.mayEdit(request, cs, userId)) {
            throw new OperationException("User not allowed to edit UGC at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException("Failed to update UGC", e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        boolean isUserPrivileged = CommentUtil.isUserPrivileged(cs.getResource(), request.getResourceResolver(), userId);
        if (!isUserPrivileged) {
            try {
                String isComposedForUserExist = this.getStringProperty(PN_COMPOSED_FOR, props);
                if (isComposedForUserExist != null) {
                    throw new OperationException("Failed to create comment on behalf of other user", 500);
                }
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to get the new composedFor property value", e, 500);
            }
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        RequestParameter[] requestParameters = request.getRequestParameters("attachmentsTobeDeleted");
        if (ArrayUtils.isNotEmpty(requestParameters)) {
            for (RequestParameter requestParameter : requestParameters) {
                String attachmentPath = requestParameter.getString();
                this.removeAttachment(request, session, attachmentPath);
            }
        }
        return this.update(resource, cs, props, attachments, session, userId);
    }

    public void removeAttachment(SlingHttpServletRequest request, Session session) throws OperationException {
        String attachmentPath = request.getParameter(PROP_ATT_TO_REMOVE);
        this.removeAttachment(request, session, attachmentPath);
    }

    private void removeAttachment(SlingHttpServletRequest request, Session session, String attachmentPath) throws OperationException {
        if (StringUtils.isEmpty(attachmentPath)) {
            throw new OperationException("Attachment path is empty", 400);
        }
        Resource resource = request.getResource();
        String userId = this.getAuthorizableId(request, session);
        if (userId.equals(ANONYMOUS)) {
            throw new OperationException("Session is invalid", 401);
        }
        CommentSystem cs = this.getCommentSystem(resource, session);
        if (!this.mayEdit(request, cs, userId)) {
            throw new OperationException("User not allowed to edit UGC at " + cs.getPath(), 412);
        }
        this.removeAttachment(resource, attachmentPath, session);
    }

    public void removeAttachment(Resource commentResource, String attachment, Session session) throws OperationException {
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Unable to remove attachment - " + attachment + "for comment - " + comment.getPath(), 400);
        }
        if (comment.getAttachmentMap() == null || !comment.getAttachmentMap().containsKey(attachment)) {
            throw new OperationException("Unable to remove attachment - " + attachment + "for comment - " + comment.getPath(), 400);
        }
        try {
            comment.removeAttachment(attachment);
            comment.getResource().getResourceResolver().commit();
        }
        catch (CommentException e) {
            throw new OperationException("Unable to remove attachment for comment " + comment.getPath(), e, 500);
        }
        catch (PersistenceException e) {
            throw new OperationException("Unable to remove attachment for comment " + comment.getPath(), e, 500);
        }
    }

    protected Resource update(Resource commentResource, CommentSystem cs, Map<String, Object> props, List<DataSource> attachments, Session session, String author) throws OperationException {
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Failed to get Commment for target " + commentResource.getPath(), 404);
        }
        if (comment.isClosed() && !CollabUtil.hasModeratePermissions(commentResource)) {
            throw new OperationException("Update attempted on closed comment: " + commentResource.getPath(), 400);
        }
        U updateOperation = this.getUpdateOperation();
        this.performBeforeActions(updateOperation, session, comment.getResource(), props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + comment.getResource().getPath() + "' ", 404);
        }
        try {
            ModifiableValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
            Calendar oldPublishDate = (Calendar)((Object)properties.get("publishDate", Calendar.class));
            boolean usedToBeDraft = properties.get("isDraft", false);
            if (props.containsKey(TAGS_PROPERTY)) {
                props.put(CQ_TAGS_PROPERTY, props.get(TAGS_PROPERTY));
                props.remove(TAGS_PROPERTY);
            }
            if (!props.containsKey("mentions")) {
                props.remove("mentions");
                properties.remove("mentions");
            } else {
                properties.put("mentions", props.get("mentions"));
            }
            properties.remove(CQ_TAGS_PROPERTY);
            if (props.containsKey(PROP_MESSAGE)) {
                long messageCharacterLimit = cs.getMessageCharacterLimit();
                String message = CollabUtil.getValueString(props.get(PROP_MESSAGE));
                if (message == null) {
                    throw new OperationException("Null value for comment message.", 400);
                }
                String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
                if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
                    throw new OperationException("Parameter message exceeded character limit", 400);
                }
                message = this.encodeMessageIfNeeded(message, props, cs.isRteEnabled());
                properties.put("jcr:description", message);
            }
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (StringUtils.equals(entry.getKey(), PROP_MESSAGE)) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
            if (cs.isModerated()) {
                properties.remove("approved");
            }
            properties.put("moderate", Boolean.TRUE);
            properties.put("cq:lastModified", Calendar.getInstance());
            if (CollabUtil.hasModeratePermissions(comment.getResource())) {
                properties.put("cq:lastModifiedBy", session.getUserID());
            } else {
                properties.put("cq:lastModifiedBy", comment.getAuthor().getId());
            }
            this.updateAttachments(comment, attachments);
            boolean isCurrentDraft = false;
            if (props.containsKey("isDraft")) {
                isCurrentDraft = (Boolean)props.get("isDraft");
            }
            Calendar currentPublishDate = null;
            if (props.containsKey("publishDate")) {
                currentPublishDate = (Calendar)props.get("publishDate");
            }
            boolean cancelJob = false;
            boolean forcePublish = false;
            if (!isCurrentDraft && usedToBeDraft && oldPublishDate != null) {
                cancelJob = true;
            } else if (isCurrentDraft && oldPublishDate != null && (currentPublishDate == null || oldPublishDate.compareTo(currentPublishDate) != 0)) {
                cancelJob = true;
            }
            if (isCurrentDraft && currentPublishDate != null && currentPublishDate.compareTo(Calendar.getInstance()) <= 0) {
                properties.put("isDraft", Boolean.FALSE);
                properties.put("cq:lastModified", currentPublishDate);
                properties.put("added", currentPublishDate.getTime());
                cancelJob = true;
                forcePublish = true;
            }
            if (cancelJob) {
                String oldJob = (String)((Object)properties.get("publishJobId", String.class));
                if (currentPublishDate == null) {
                    properties.remove("publishDate");
                }
                if (StringUtils.isNotEmpty(oldJob)) {
                    this.futurePostScheduler.unschedule(oldJob);
                    properties.remove("publishJobId");
                }
            }
            if (!isCurrentDraft && usedToBeDraft) {
                properties.put("publishDate", Calendar.getInstance());
            }
            comment.getResource().getResourceResolver().commit();
            Comment updatedComment = comment.getResource().adaptTo(Comment.class);
            S commentComp = this.getSocialComponentForResource(updatedComment.getResource());
            if (!isCurrentDraft) {
                if (!usedToBeDraft) {
                    this.postUpdateEvent(commentComp, author);
                } else {
                    this.postCreateEvent(commentComp, author);
                }
            } else if (forcePublish) {
                this.postCreateEvent(commentComp, author);
            }
            this.performAfterActions(updateOperation, session, commentComp, props);
            return updatedComment.getResource();
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
        catch (PersistenceException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
    }

    protected void updateAttachments(Comment comment, List<DataSource> attachments) {
        if (attachments != null) {
            comment.addAttachments(attachments);
        }
    }

    public Resource update(Resource commentResource, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        return this.update(commentResource, cs, props, attachments, session, commentResource.getResourceResolver().getUserID());
    }

    public void delete(SlingHttpServletRequest request, Session session) throws OperationException {
        this.delete(request, session, Collections.<String, Object>emptyMap());
    }

    public void delete(SlingHttpServletRequest request, Session session, Map<String, Object> conditionals) throws OperationException {
        Resource reqResource = request.getResource();
        CommentSystem cs = this.getCommentSystem(reqResource, session);
        Comment comment = this.getComment(reqResource, session);
        boolean isDraft = comment.getProperty("isDraft", false);
        String userId = this.getAuthorizableId(request, session);
        if (userId.equals(ANONYMOUS)) {
            throw new OperationException("Session is invalid", 401);
        }
        if (!cs.allowsDelete() && !isDraft) {
            throw new OperationException("Deletion is not enabling.", 403);
        }
        if (!this.mayDelete(request, cs, userId)) {
            throw new OperationException("User not allowed to delete " + cs.getPath(), 404);
        }
        if (conditionals.isEmpty()) {
            this.delete(reqResource, cs, session);
        } else {
            this.delete(reqResource, cs, session, conditionals);
        }
    }

    public void delete(Resource commentResource, Session session) throws OperationException {
        this.delete(commentResource, session, Collections.<String, Object>emptyMap());
    }

    public void delete(Resource commentResource, Session session, Map<String, Object> conditionals) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        this.delete(commentResource, cs, session, conditionals);
    }

    public Resource move(SlingHttpServletRequest request, Session session) throws OperationException {
        String resourcePath = request.getParameter("resourcePath");
        String parentPath = request.getParameter("parentPath");
        ResourceResolver resolver = request.getResourceResolver();
        if (null == resolver) {
            throw new OperationException("Request does not provide a resource resolver", 403);
        }
        Resource resource = resolver.getResource(resourcePath);
        if (null == resource) {
            throw new OperationException("The resource to be moved could not be found at " + resourcePath, 404);
        }
        Resource parent = resolver.getResource(parentPath);
        if (null == parent) {
            throw new OperationException("The target resource could not be found at " + parentPath, 404);
        }
        return this.move(resource, parent, request.getResourceResolver().adaptTo(Session.class));
    }

    public Resource move(Resource commentResource, Resource parentResource, Session session) throws OperationException {
        ResourceResolver resolver = commentResource.getResourceResolver();
        String resourcePath = commentResource.getPath();
        String parentPath = parentResource.getPath();
        SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
        String testPath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
        Boolean needMove = SocialResourceUtils.isCloudUGC(resourcePath) ? !socialUtils.resourceToUGCStoragePath(parentResource).equals(testPath) : !parentPath.equals(testPath);
        if (needMove.booleanValue()) {
            try {
                if (!socialUtils.hasModeratePermissions(commentResource) || !socialUtils.hasModeratePermissions(parentResource)) {
                    throw new OperationException("The user does not have sufficient privileges to perform the move operation", 403);
                }
                if (!SocialResourceUtils.isCloudUGC(parentPath)) {
                    session.checkPermission(socialUtils.resourceToUGCStoragePath(parentResource), "add_node");
                } else {
                    session.checkPermission(parentPath, "add_node");
                }
            }
            catch (AccessControlException e) {
                throw new OperationException("The user does not have sufficient privileges to perform the move operation", e, 403);
            }
            catch (RepositoryException e) {
                throw new OperationException("Unable to complete a permission check", e, 500);
            }
            SocialResourceProvider srp = socialUtils.getConfiguredProvider(commentResource);
            try {
                Boolean isPinned;
                Resource newResource = srp.move(resolver, resourcePath, parentPath);
                if (null == newResource) {
                    srp.revert(resolver);
                    throw new OperationException("Unable to move " + resourcePath + " to " + parentPath, 500);
                }
                U createOperation = this.getCreateOperation();
                Map props = newResource.adaptTo(ModifiableValueMap.class);
                S commentComp = this.getSocialComponentForResource(newResource);
                Boolean allowPinning = commentComp.getConfiguration().isPinAllowed();
                Boolean bl = isPinned = props.get("isPinned_b") == null ? Boolean.valueOf(false) : props.get("isPinned_b");
                if (!allowPinning.booleanValue() && isPinned.booleanValue()) {
                    props.remove("isPinned_b");
                }
                this.performBeforeActions(createOperation, session, resolver.getResource((String)props.get("social:rootCommentSystem")), props);
                srp.commit(resolver);
                this.performAfterActions(createOperation, session, commentComp, props);
                this.postCreateEvent(commentComp, session.getUserID());
                return newResource;
            }
            catch (PersistenceException e) {
                srp.revert(resolver);
                throw new OperationException("Unable to move " + resourcePath + " to " + parentPath, e, 500);
            }
        }
        return commentResource;
    }

    public Resource changeState(Resource commentResource, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        return this.changeState(commentResource, cs, author, props, session);
    }

    public Resource changeState(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        String name = this.getAuthorizableId(request, session);
        CommentSystem cs = this.getCommentSystem(resource, session);
        Comment comment = this.getComment(resource, session);
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            String isAddReply;
            String toState;
            this.getDefaultProperties(request, props, session);
            String operation = request.getParameter(PROPERTY_STATE_OPERATION);
            if (StringUtils.isNotBlank(operation)) {
                props.put(PROPERTY_STATE_OPERATION, operation);
            }
            if (StringUtils.isNotBlank(toState = request.getParameter(PROPERTY_TOSTATE))) {
                props.put(PROPERTY_TOSTATE, toState);
            }
            if (StringUtils.isNotBlank(isAddReply = request.getParameter(PROPERTY_ADD_REPLY))) {
                props.put(PROPERTY_ADD_REPLY, Boolean.parseBoolean(isAddReply));
            }
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException("Failed to change comment state", e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        return this.changeState(resource, cs, name, props, session);
    }

    protected Resource changeState(Resource commentResource, CommentSystem cs, String author, Map<String, Object> props, Session session) throws OperationException {
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Failed to get Commment for target " + commentResource.getPath(), 404);
        }
        if (comment.isClosed() && !CollabUtil.hasModeratePermissions(commentResource)) {
            throw new OperationException("Update attempted on closed comment: " + commentResource.getPath(), 400);
        }
        U changeStateOperation = this.getChangeStateOperation();
        this.performBeforeActions(changeStateOperation, session, comment.getResource(), props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + comment.getResource().getPath() + "' ", 404);
        }
        if (!props.containsKey(PROPERTY_STATE_OPERATION)) {
            throw new OperationException("Cannot find state operation from request", 400);
        }
        String operation = (String)props.get(PROPERTY_STATE_OPERATION);
        if (!props.containsKey(PROPERTY_TOSTATE)) {
            throw new OperationException("Cannot find tostate from request", 400);
        }
        String toState = (String)props.get(PROPERTY_TOSTATE);
        StateMachine stateMachine = commentResource.adaptTo(StateMachine.class);
        S commentComp = this.getSocialComponentForResource(comment.getResource());
        State state = stateMachine.getState(commentComp.getState());
        String role = null;
        boolean validOp = false;
        if (state != null) {
            if (CollabUtil.hasModeratePermissions(commentResource)) {
                validOp = state.canPerformOperation(MODERATORS_ROLE, operation);
                role = MODERATORS_ROLE;
            }
            if (!validOp && CollabUtil.isResourceOwner(commentResource)) {
                validOp = state.canPerformOperation(OWNER_ROLE, operation);
                role = OWNER_ROLE;
            }
        } else {
            throw new OperationException("Failed to get state for target " + commentResource.getPath(), 404);
        }
        if (!validOp) {
            throw new OperationException("Failed to change comment state", 203);
        }
        state.performOperation(commentResource, comment.getResource().getResourceResolver(), role, operation, toState);
        Resource replyRes = null;
        if (props.containsKey(PROPERTY_ADD_REPLY) && ((Boolean)props.get(PROPERTY_ADD_REPLY)).booleanValue()) {
            replyRes = this.create(commentResource, cs, author, props, Collections.<DataSource>emptyList(), session);
        }
        this.postChangeStateEvent(commentComp, author);
        this.performAfterActions(changeStateOperation, session, commentComp, props);
        return replyRes == null ? commentResource : replyRes;
    }

    public void delete(Resource commentResource, CommentSystem cs, Session session) throws OperationException {
        this.delete(commentResource, cs, session, Collections.<String, Object>emptyMap());
    }

    public void delete(Resource commentResource, CommentSystem cs, Session session, Map<String, Object> conditionals) throws OperationException {
        LOG.debug("delete for  {} ", (Object)commentResource.getPath());
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Unable to get comment for resource at " + commentResource.getPath(), 404);
        }
        if (comment.isClosed() && !CollabUtil.hasModeratePermissions(commentResource)) {
            throw new OperationException("Delete attempted on closed comment: " + commentResource.getPath(), 400);
        }
        S commentComp = this.getSocialComponentForResource(comment.getResource());
        U deleteOperation = this.getDeleteOperation();
        this.performBeforeActions(deleteOperation, session, comment.getResource(), Collections.<String, Object>emptyMap());
        commentComp.getParentComponent();
        String author = commentResource.getResourceResolver().getUserID();
        boolean throwEvent = true;
        ValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
        Boolean isDraft = (Boolean)((Object)properties.get("isDraft", Boolean.class));
        if (isDraft != null && isDraft.booleanValue()) {
            throwEvent = false;
            String oldJob = (String)((Object)properties.get("publishJobId", String.class));
            if (StringUtils.isNotEmpty(oldJob)) {
                this.futurePostScheduler.unschedule(oldJob);
            }
        }
        ArrayList<String> comments = new ArrayList<String>();
        CommentUtil.getComments(comment, comments);
        ResourceResolver resolver = comment.getResource().getResourceResolver();
        comment.remove();
        comment.getCommentSystem().save();
        if (throwEvent && (conditionals.get(IGNORE_EVENT_POST) == null || Boolean.valueOf(conditionals.get(IGNORE_EVENT_POST).equals(false)).booleanValue())) {
            this.postDeleteEvent(commentComp, author);
        }
        this.deleteActivities(comments, resolver);
        this.deleteRelationships(commentResource, resolver);
        this.performAfterActions(deleteOperation, session, commentComp, Collections.<String, Object>emptyMap());
    }

    private void deleteActivities(List<String> comments, ResourceResolver resolver) throws OperationException {
        for (String commentPath : comments) {
            List<Resource> activityResources = CommentUtil.getActivitiesForComment(resolver, commentPath);
            if (activityResources == null) continue;
            try {
                for (Resource activityResource : activityResources) {
                    resolver.delete(activityResource);
                    resolver.commit();
                }
            }
            catch (PersistenceException e) {
                LOG.warn("Failed to delete activity for comment '{}'", (Object)commentPath);
            }
        }
    }

    private void deleteRelationships(Resource commentResource, ResourceResolver resolver) {
        String[] types = new String[]{SUBSCRIPTION, NOTIFICATION, ACTIVITYSTREAMS};
        SocialGraph graph = resolver.adaptTo(SocialGraph.class);
        Vertex subscriptionTargetNode = graph.getVertex(commentResource.getPath());
        if (subscriptionTargetNode != null) {
            for (int i = 0; i < types.length; ++i) {
                Iterable<Relationship> relationships = subscriptionTargetNode.getRelationships(Direction.INCOMING, types[i]);
                if (relationships == null) continue;
                for (Relationship relationship : relationships) {
                    relationship.delete();
                }
            }
        }
        try {
            resolver.commit();
        }
        catch (PersistenceException ex) {
            LOG.warn("Failed to delete subscriptions for comment '{}'", (Object)commentResource.getPath());
        }
    }

    private List<String> getPaths(ResourceResolver resolver, String path) throws RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            return paths;
        }
        for (Resource child : resource.getChildren()) {
            paths.addAll(this.getPaths(resolver, child.getPath()));
        }
        paths.add(path);
        return paths;
    }

    private String getUGCLimitModerators(String[] moderatorList) {
        StringBuilder strBuilder = new StringBuilder();
        if (moderatorList != null && moderatorList.length != 0) {
            strBuilder.append(moderatorList[0]);
            for (int i = 1; i < moderatorList.length; ++i) {
                strBuilder.append(", " + moderatorList[i]);
            }
            return "Please contact :" + strBuilder.toString();
        }
        return "";
    }

    private String getDurationString(long duration) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        long day = 86400000L;
        String durationString = "minute";
        if (duration < 60000L) {
            long t = Math.round(duration / 1000L);
            if (t == 1L) {
                durationString = "second";
            }
            durationString = "second";
        } else if (duration < 3600000L) {
            long t = Math.round(duration / 60000L);
            if (t == 1L) {
                durationString = "minute";
            }
            durationString = "minute";
        } else if (duration < 86400000L) {
            long t = Math.round(duration / 3600000L);
            if (t == 1L) {
                durationString = "hour";
            }
            durationString = "hour";
        } else {
            durationString = "day";
        }
        return durationString;
    }

    protected String getEntityUrl(Resource resource) {
        return resource.adaptTo(CommentSystem.class).getUrl();
    }

    protected String getEventTopic() {
        return "comment";
    }

    @Deprecated
    protected void bindUserManagerFactory(Object in) {
        this.unbindUserManagerFactory(in);
    }

    @Deprecated
    protected void unbindUserManagerFactory(Object in) {
        if (!userManagerCompatibilityMessageLogged.getAndSet(true)) {
            LOG.info("Service binding for deprecated and unsupported UserManagerFactory encountered. Ensure all direct and indirect uses of AbstractCommentOperationService are recompiled with the latest applicable code.");
        }
    }

    protected abstract S getSocialComponentForResource(Resource var1);

    protected abstract void postCreateEvent(S var1, String var2);

    protected abstract void postUpdateEvent(S var1, String var2);

    protected abstract void postChangeStateEvent(S var1, String var2);

    protected abstract void postDeleteEvent(S var1, String var2);

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getUploadImageOperation();

    protected abstract U getChangeStateOperation();

    protected abstract String getResourceType(Resource var1);

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindFuturePostScheduler(ScheduledPostService scheduledPostService) {
        this.futurePostScheduler = scheduledPostService;
    }

    protected void unbindFuturePostScheduler(ScheduledPostService scheduledPostService) {
        if (this.futurePostScheduler == scheduledPostService) {
            this.futurePostScheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindUgcLimiterService(UGCLimiterService uGCLimiterService) {
        this.ugcLimiterService = uGCLimiterService;
    }

    protected void unbindUgcLimiterService(UGCLimiterService uGCLimiterService) {
        if (this.ugcLimiterService == uGCLimiterService) {
            this.ugcLimiterService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindExtensionManager(InheritedOperationExtensionManager inheritedOperationExtensionManager) {
        this.extensionManager = inheritedOperationExtensionManager;
    }

    protected void unbindExtensionManager(InheritedOperationExtensionManager inheritedOperationExtensionManager) {
        if (this.extensionManager == inheritedOperationExtensionManager) {
            this.extensionManager = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    private class MentionsData {
        private Set<String> mentionedUsers;
        private String ugcMessage;

        public MentionsData(Set<String> mentionedUsers, String ugcMessage) {
            this.mentionedUsers = mentionedUsers;
            this.ugcMessage = ugcMessage;
        }
    }
}

