/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.listing;

import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.FullTextConstraint;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFilterUtil {
    private static final String PROP_TAG = "tag";
    private static final String NULL_STRING = "null";
    public static final String PROP_USER_DISPLAY_NAME = "author_display_name";
    private static Map<String, Integer> MAP_INDEXED_TYPE = new HashMap<String, Integer>();
    private static final Logger LOG;
    private static int NUMBER_FILTER_TOKENS;
    private static int FILTER_PROP_INDEX;
    private static int FILTER_OPERATOR_INDEX;
    private static int FILTER_EXPRESSION_INDEX;

    public static void parseOrFilters(String expressions, Map<String, ConstraintGroup> orFilters) throws QueryFilterException {
        QueryFilterUtil.parseOrFilters(expressions, orFilters, false);
    }

    public static void parseOrFilters(String expressions, Map<String, ConstraintGroup> orFilters, boolean bSupportsMultiLingualSearch) throws QueryFilterException {
        if (StringUtils.isEmpty(expressions)) {
            throw new QueryFilterException("Empty filter.");
        }
        String[] filters = expressions.split("(?<!\\\\),");
        for (int i = 0; i < filters.length; ++i) {
            QueryFilter queryExpression = QueryFilter.parse(filters[i], Operator.Or, bSupportsMultiLingualSearch);
            String constraintGroupName = queryExpression.getName();
            if (!orFilters.containsKey(constraintGroupName)) {
                ConstraintGroup cg = new ConstraintGroup();
                cg.setOperator(Operator.And);
                orFilters.put(constraintGroupName, cg);
            }
            orFilters.get(constraintGroupName).addConstraint(queryExpression.getConstraint());
        }
    }

    private static Date parseDate(String dateString) throws QueryFilterException {
        Date date;
        if (StringUtils.isNumeric(dateString)) {
            date = new Date(Long.parseLong(dateString));
        } else if (StringUtils.equalsIgnoreCase(dateString, NULL_STRING)) {
            date = null;
        } else {
            try {
                Calendar calendar = DatatypeConverter.parseDateTime((String)dateString);
                date = calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                throw new QueryFilterException("Error parsing input string", e);
            }
        }
        return date;
    }

    private static Object getPropertyValue(String name, String input) throws QueryFilterException {
        Integer type = MAP_INDEXED_TYPE.get(name);
        if (type != null) {
            switch (MAP_INDEXED_TYPE.get(name)) {
                case 1: 
                case 3: {
                    return input;
                }
                case 6: {
                    Boolean value = Boolean.valueOf(input);
                    return value.toString();
                }
                case 5: {
                    return QueryFilterUtil.parseDate(input);
                }
            }
            throw new QueryFilterException("The type of the " + name + "proeprty is not supported.");
        }
        String datatype = name.substring(name.lastIndexOf("_") + 1);
        try {
            DATA_TYPE paramDataType = DATA_TYPE.getEnum(datatype);
            if (DATA_TYPE.STRING.equals((Object)paramDataType) || DATA_TYPE.STRING_ARRAY.equals((Object)paramDataType) || DATA_TYPE.LONG.equals((Object)paramDataType)) {
                return input;
            }
            if (DATA_TYPE.BOOLEAN.equals((Object)paramDataType)) {
                Boolean value = Boolean.valueOf(input);
                return value.toString();
            }
            if (DATA_TYPE.DATE.equals((Object)paramDataType)) {
                return QueryFilterUtil.parseDate(input);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unsupported data type:% for:%", (Object)datatype, (Object)name);
        }
        throw new QueryFilterException("The property " + name + "is not indexed.");
    }

    public static List<ConstraintGroup> parseFilter(String[] filters) throws QueryFilterException {
        return QueryFilterUtil.parseFilter(filters, false);
    }

    public static List<ConstraintGroup> parseFilter(String[] filters, boolean bSupportsMultiLingualSearch) throws QueryFilterException {
        HashMap<String, ConstraintGroup> orFiltersMap = new HashMap<String, ConstraintGroup>();
        ArrayList<ConstraintGroup> andFilters = new ArrayList<ConstraintGroup>();
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                ConstraintGroup cg = new ConstraintGroup();
                cg.setOperator(Operator.And);
                andFilters.add(cg);
                QueryFilterUtil.parseOrFilters(filters[i], orFiltersMap, bSupportsMultiLingualSearch);
                for (Map.Entry entry : orFiltersMap.entrySet()) {
                    cg.or((Constraint)entry.getValue());
                }
                orFiltersMap.clear();
            }
        }
        return andFilters;
    }

    static {
        MAP_INDEXED_TYPE.put("jcr:primaryType", 1);
        MAP_INDEXED_TYPE.put(":uuid", 1);
        MAP_INDEXED_TYPE.put(":path", 1);
        MAP_INDEXED_TYPE.put(":parent", 1);
        MAP_INDEXED_TYPE.put(":name", 1);
        MAP_INDEXED_TYPE.put("isFlagged", 6);
        MAP_INDEXED_TYPE.put("isSpam", 6);
        MAP_INDEXED_TYPE.put("read", 6);
        MAP_INDEXED_TYPE.put("influence", 6);
        MAP_INDEXED_TYPE.put("attachments", 6);
        MAP_INDEXED_TYPE.put("sentiment", 3);
        MAP_INDEXED_TYPE.put("flagged", 6);
        MAP_INDEXED_TYPE.put("added", 5);
        MAP_INDEXED_TYPE.put("modifiedDate", 5);
        MAP_INDEXED_TYPE.put("state", 1);
        MAP_INDEXED_TYPE.put("userIdentifier", 1);
        MAP_INDEXED_TYPE.put("parentPath", 1);
        MAP_INDEXED_TYPE.put("parentTitle", 1);
        MAP_INDEXED_TYPE.put("replies", 3);
        MAP_INDEXED_TYPE.put("jcr:title", 1);
        MAP_INDEXED_TYPE.put("jcr:description", 1);
        MAP_INDEXED_TYPE.put("attachments", 6);
        MAP_INDEXED_TYPE.put("sling:resourceType", 1);
        MAP_INDEXED_TYPE.put("parentPath", 1);
        MAP_INDEXED_TYPE.put("parentTitle", 1);
        MAP_INDEXED_TYPE.put("allowThreadedReply", 6);
        MAP_INDEXED_TYPE.put("isDraft", 6);
        MAP_INDEXED_TYPE.put("publishDate", 5);
        MAP_INDEXED_TYPE.put("publishJobId", 1);
        MAP_INDEXED_TYPE.put("answered", 6);
        MAP_INDEXED_TYPE.put("chosenanswered", 6);
        MAP_INDEXED_TYPE.put(PROP_TAG, 1);
        MAP_INDEXED_TYPE.put("cq:tags", 1);
        MAP_INDEXED_TYPE.put(PROP_USER_DISPLAY_NAME, 1);
        MAP_INDEXED_TYPE.put("location_t", 1);
        MAP_INDEXED_TYPE.put("social:key", 1);
        MAP_INDEXED_TYPE.put("verb", 1);
        LOG = LoggerFactory.getLogger(QueryFilterUtil.class);
        NUMBER_FILTER_TOKENS = 3;
        FILTER_PROP_INDEX = 0;
        FILTER_OPERATOR_INDEX = 1;
        FILTER_EXPRESSION_INDEX = 2;
    }

    public static class QueryFilter {
        private final Constraint constraint;
        private final String name;
        private final String value;
        private final Comparator comp;

        private QueryFilter(String name, Comparator comp, String value, Operator operator2) throws QueryFilterException {
            if (StringUtils.isEmpty(name)) {
                throw new QueryFilterException("Name parameter can not be null.");
            }
            if (comp == null) {
                throw new QueryFilterException("Invalid comparator value");
            }
            if (StringUtils.isEmpty(value)) {
                throw new QueryFilterException("Value parameter can not be null.");
            }
            if (operator2 == null) {
                throw new QueryFilterException("Operator parameter can not be null.");
            }
            this.name = name;
            this.value = value;
            this.comp = comp;
            Object typedValue = QueryFilterUtil.getPropertyValue(name, value);
            this.constraint = this.isTextSearchProperty(name, comp) && typedValue instanceof String ? new FullTextConstraint((String)typedValue, name, operator2) : new ValueConstraint<Object>(name, typedValue, comp.getComparisonType(), operator2);
        }

        public Constraint getConstraint() {
            return this.constraint;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Comparator getComparator() {
            return this.comp;
        }

        public static QueryFilter parse(String filter, Operator operator2) throws QueryFilterException {
            return QueryFilter.parse(filter, operator2, false);
        }

        public static QueryFilter parse(String filter, Operator operator2, boolean bSupportsMultiLingualSearch) throws QueryFilterException {
            String[] words = filter.trim().split(" ", NUMBER_FILTER_TOKENS);
            if (words.length < NUMBER_FILTER_TOKENS) {
                throw new QueryFilterException("Invalid filter expression: " + filter);
            }
            String name = words[FILTER_PROP_INDEX].trim();
            if (name.equals(QueryFilterUtil.PROP_TAG)) {
                name = "cq:tags";
            }
            Comparator comp = Comparator.fromString(words[FILTER_OPERATOR_INDEX].trim());
            String value = QueryFilter.escapeQueryValue(words[FILTER_EXPRESSION_INDEX].trim(), bSupportsMultiLingualSearch);
            return new QueryFilter(name, comp, value, operator2);
        }

        private boolean isTextSearchProperty(String name, Comparator comp) {
            return comp == Comparator.LIKE;
        }

        private static String escapeQueryValue(String value, boolean bSupportsMultiLingualSearch) {
            String escapeValue = value;
            if (escapeValue.startsWith("'") && escapeValue.endsWith("'")) {
                escapeValue = escapeValue.substring(1, escapeValue.length() - 1);
            }
            if (!bSupportsMultiLingualSearch && escapeValue.length() > 1 && escapeValue.startsWith("\"") && escapeValue.endsWith("\"")) {
                escapeValue = escapeValue.substring(1, escapeValue.length() - 1);
            }
            if (escapeValue.contains("\\,")) {
                escapeValue = escapeValue.replace("\\,", ",");
            }
            return escapeValue;
        }
    }

    public static enum Comparator {
        EQ(ComparisonType.Equals),
        NE(ComparisonType.NotEquals),
        LT(ComparisonType.LessThan),
        LTE(ComparisonType.LessThanOrEqualTo),
        GT(ComparisonType.GreaterThan),
        GTE(ComparisonType.GreaterThanOrEqualTo),
        LIKE(null);

        ComparisonType comparator;

        private Comparator(ComparisonType comparator) {
            this.comparator = comparator;
        }

        ComparisonType getComparisonType() {
            return this.comparator;
        }

        public static Comparator fromString(String text) throws QueryFilterException {
            if (text == null || text.length() == 0) {
                return null;
            }
            return Comparator.valueOf(text.toUpperCase());
        }
    }

    public static enum DATA_TYPE {
        STRING("s"),
        STRING_ARRAY("ss"),
        BOOLEAN("b"),
        LONG("l"),
        DATE("dt");

        private final String type;

        private DATA_TYPE(String t) {
            this.type = t;
        }

        public String toString() {
            return String.valueOf(this.type);
        }

        public static DATA_TYPE getEnum(String value) {
            for (DATA_TYPE dt : DATA_TYPE.values()) {
                if (!StringUtils.equals(dt.type, value)) continue;
                return dt;
            }
            throw new IllegalArgumentException("Unsupported data type " + value);
        }
    }

    public static class QueryFilterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public QueryFilterException(String msg) {
            super(msg);
        }

        public QueryFilterException(String msg, Exception cause) {
            super(msg, cause);
        }

        public QueryFilterException(Exception cause) {
            super(cause);
        }
    }
}

