/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.ui.impl;

import com.adobe.cq.social.connect.ui.Configuration;
import com.adobe.cq.social.connect.ui.Constants;
import com.adobe.cq.social.connect.ui.impl.Permissions;
import com.adobe.cq.social.connect.ui.impl.ResourceHelper;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Configuration.class})
public class ConfigurationImpl
implements Configuration {
    @Self(injectionStrategy=InjectionStrategy.REQUIRED)
    private SlingHttpServletRequest request;
    @SlingObject(injectionStrategy=InjectionStrategy.REQUIRED)
    private ResourceResolver resourceResolver;
    @SlingObject(injectionStrategy=InjectionStrategy.REQUIRED)
    private Resource resource;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Resource useResource;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String uniqueConfigName;

    public String getTitle() {
        return this.getResource().getValueMap().get("jcr:content/jcr:title", this.getResource().getValueMap().get("jcr:title", this.getResource().getName()));
    }

    public boolean hasChildren() {
        if (this.getResource().hasChildren()) {
            for (Resource child : this.getResource().getChildren()) {
                boolean isContainer = ResourceHelper.isConfigurationContainer(child);
                boolean hasSetting = ResourceHelper.hasSetting(child, Constants.CLOUDCONFIG_PATH);
                if (!isContainer && !hasSetting) continue;
                return true;
            }
        }
        return false;
    }

    public String getThumbnail() {
        if (ResourceHelper.isConfiguration(this.getResource())) {
            String templateThubnail;
            Template template;
            Page page = this.getResource().adaptTo(Page.class);
            if (page != null && (template = page.getTemplate()) != null && StringUtils.isNotBlank(templateThubnail = template.getThumbnailPath())) {
                return templateThubnail;
            }
            return "/libs/cq/ui/widgets/themes/default/icons/240x180/page.png";
        }
        return null;
    }

    public Calendar getLastModifiedDate() {
        Page page = this.getResource().adaptTo(Page.class);
        if (page != null) {
            return page.getLastModified();
        }
        ValueMap props = this.getResource().adaptTo(ValueMap.class);
        if (props != null) {
            return (Calendar)((Object)props.get("jcr:lastModified", Calendar.class));
        }
        return null;
    }

    public String getLastModifiedBy() {
        Page page = this.getResource().adaptTo(Page.class);
        if (page != null) {
            return page.getLastModifiedBy();
        }
        ValueMap props = this.getResource().adaptTo(ValueMap.class);
        if (props != null) {
            return (String)((Object)props.get("jcr:lastModifiedBy", String.class));
        }
        return null;
    }

    public Calendar getLastPublishedDate() {
        ReplicationStatus replicationStatus = this.getResource().adaptTo(ReplicationStatus.class);
        if (replicationStatus != null) {
            return replicationStatus.getLastPublished();
        }
        return null;
    }

    public Set<String> getQuickactionsRels() {
        LinkedHashSet<String> quickactions = new LinkedHashSet<String>();
        if (ResourceHelper.isConfiguration(this.getResource())) {
            if (Permissions.hasPermission(this.resourceResolver, this.getResource().getPath(), "jcr:modifyProperties")) {
                quickactions.add("cq-confadmin-actions-properties-activator");
            }
            if (Permissions.hasPermission(this.resourceResolver, this.getResource().getPath(), "crx:replicate")) {
                quickactions.add("cq-confadmin-actions-publish-activator");
                quickactions.add("cq-confadmin-actions-unpublish-activator");
            }
            if (Permissions.hasPermission(this.resourceResolver, this.getResource().getPath(), "jcr:removeChildNodes")) {
                quickactions.add("cq-confadmin-actions-delete-activator");
            }
        } else if (this.hasChildren()) {
            boolean uniqueConfAlreadyExists = false;
            if (this.getUniqueConfigName() != null) {
                uniqueConfAlreadyExists = ResourceHelper.checkConfNodeExists(this.getResource(), this.getUniqueConfigName());
                if (!uniqueConfAlreadyExists) {
                    quickactions.add("cq-confadmin-actions-createconfig-activator");
                } else {
                    quickactions.add("none");
                }
            }
        }
        return quickactions;
    }

    private Resource getResource() {
        if (this.useResource != null) {
            return this.useResource;
        }
        return this.resource;
    }

    private String getUniqueConfigName() {
        if (this.uniqueConfigName != null) {
            return this.uniqueConfigName;
        }
        return null;
    }
}

