/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.ui.impl;

import com.adobe.cq.social.connect.ui.Constants;
import com.adobe.cq.social.connect.ui.Meta;
import com.adobe.cq.social.connect.ui.impl.Permissions;
import com.adobe.cq.social.connect.ui.impl.ResourceHelper;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Meta.class})
public class MetaImpl
implements Meta {
    @Self(injectionStrategy=InjectionStrategy.REQUIRED)
    private SlingHttpServletRequest request;
    @SlingObject(injectionStrategy=InjectionStrategy.REQUIRED)
    private ResourceResolver resourceResolver;
    private Resource resource;

    @PostConstruct
    protected void postConstruct() {
        String suffix = this.request.getRequestPathInfo().getSuffix();
        this.resource = this.resourceResolver.getResource(suffix);
    }

    public boolean isFolder() {
        return ResourceHelper.isResourceType(this.resource, "nt:folder", "sling:Folder", "sling:OrderedFolder");
    }

    public String getTitle() {
        if (this.resource != null) {
            return this.resource.getValueMap().get("jcr:content/jcr:title", this.resource.getValueMap().get("jcr:title", this.resource.getName()));
        }
        return null;
    }

    public Set<String> getActionsRels() {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        if (this.resource != null && this.request != null) {
            Resource contentResource = this.request.getResource();
            String uniqueConfName = null;
            boolean uniqueConfAlreadyExists = false;
            if (contentResource != null) {
                if (contentResource.getValueMap().get("uniqueConfigName") != null) {
                    uniqueConfName = contentResource.getValueMap().get("uniqueConfigName").toString();
                }
                boolean isRoot = Constants.CONF_ROOT.equals(this.resource.getPath());
                boolean hasCapability = this.resource.getChild(Constants.CLOUDCONFIG_BUCKET_PATH) != null;
                boolean hasSetting = ResourceHelper.hasSetting(this.resource, Constants.SETTINGS_PATH);
                if (uniqueConfName != null && StringUtils.isNotEmpty(uniqueConfName)) {
                    uniqueConfAlreadyExists = ResourceHelper.checkConfNodeExists(this.resource, uniqueConfName);
                }
                if (!isRoot && hasCapability && !hasSetting && !uniqueConfAlreadyExists && Permissions.hasPermission(this.resourceResolver, this.resource.getPath(), "{http://www.jcp.org/jcr/1.0}addChildNodes")) {
                    actions.add("cq-confadmin-actions-createconfig-activator");
                }
            }
        }
        return actions;
    }
}

