/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.ui.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Permissions {
    private static final Logger LOG = LoggerFactory.getLogger(Permissions.class);

    private Permissions() {
    }

    public static boolean hasPermission(ResourceResolver resourceResolver, String path, String privilege) {
        try {
            AccessControlManager acm;
            Session session = resourceResolver.adaptTo(Session.class);
            AccessControlManager accessControlManager = acm = session != null ? session.getAccessControlManager() : null;
            if (acm != null && StringUtils.isNotEmpty(path) && StringUtils.isNotEmpty(privilege)) {
                Privilege p = acm.privilegeFromName(privilege);
                return acm.hasPrivileges(path, new Privilege[]{p});
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to verify privilege " + privilege + " for path " + path, e);
        }
        return false;
    }
}

