/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.ui.impl;

import com.adobe.cq.social.connect.ui.Constants;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static boolean isResourceType(Resource resource, String ... resourceTypes) {
        if (resource != null && resourceTypes != null) {
            for (String resourceType : resourceTypes) {
                Resource child = resource.getChild("jcr:content");
                if (child != null) {
                    resource = child;
                }
                if (!resource.isResourceType(resourceType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConfigurationContainer(Resource resource) {
        return resource != null && StringUtils.startsWith(resource.getPath(), Constants.CONF_ROOT) && (resource.isResourceType("sling:Folder") || resource.isResourceType("sling:OrderedFolder")) && resource.getChild(Constants.CONF_CONTAINER_BUCKET_NAME) != null;
    }

    public static boolean hasSetting(Resource resource, String settingPath) {
        return resource != null && resource.getChild(settingPath) != null;
    }

    public static boolean isConfiguration(Resource resource) {
        if (resource != null) {
            Resource parent = resource;
            do {
                if (!Constants.CLOUDCONFIG_BUCKET_NAME.equals(parent.getName())) continue;
                return true;
            } while ((parent = parent.getParent()) != null);
        }
        return false;
    }

    public static boolean checkConfNodeExists(Resource resource, String uniqueConfName) {
        Resource child;
        Resource cloudconfigResource;
        Resource settingResource;
        return resource != null && ResourceHelper.isConfigurationContainer(resource) && (settingResource = resource.getChild(Constants.CONF_CONTAINER_BUCKET_NAME)) != null && (cloudconfigResource = settingResource.getChild(Constants.CLOUDCONFIG_BUCKET_NAME)) != null && (child = cloudconfigResource.getChild(uniqueConfName)) != null;
    }
}

