/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.console.utils.api.internal;

import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static <E> E get(Properties props, String key, E defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return (E)PropertiesUtils.toObject(value, defaultValue.getClass());
    }

    public static <E> E get(Map<String, Object> props, String key, E defaultValue) {
        Object value = props.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (E)props.get(key);
    }

    public static Object toObject(String value, Class clazz) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.valueOf(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            try {
                return Long.valueOf(value).byteValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).byteValue();
            }
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            try {
                return Long.valueOf(value).shortValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).shortValue();
            }
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            try {
                return Long.valueOf(value).intValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).intValue();
            }
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            try {
                return (long)Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).longValue();
            }
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            try {
                return Float.valueOf(Double.valueOf(value).floatValue());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(Long.valueOf(value).floatValue());
            }
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            try {
                return (double)Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Long.valueOf(value).doubleValue();
            }
        }
        return value;
    }
}

