/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.api.UserUtils;
import com.adobe.cq.social.enablement.resource.model.api.EnablementResourceModel;
import com.adobe.cq.social.enablement.resource.model.api.EnablementSocialCommentsModel;
import com.adobe.cq.social.enablement.resource.model.api.EnablementSocialRatingsModel;
import com.adobe.cq.social.srp.utilities.api.SocialResourceUtilities;
import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.base.util.AccessControlUtil;

public class EnablementUGCVisibilityUtils {
    private static final String[] userPrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}read"};
    private final boolean allowCatalog;
    private final boolean allowAnonymous;
    private final boolean allowComment;
    private final boolean allowRating;
    private final boolean allowSiteMemberComment;
    private final boolean allowSiteMemberRating;
    private final boolean allowEnrolleeComment;
    private final boolean allowEnrolleeRating;
    private final EnablementResourceModel erm;
    private final Resource enablementResource;
    private final ResourceResolver resourceResolver;
    private final UserManager userManager;
    private final Session session;
    private String socialUGCShadowPath;
    private String discussionPath;
    private String ratingPath;

    public EnablementUGCVisibilityUtils(EnablementResourceModel enablementResourceModel) {
        this.erm = enablementResourceModel;
        this.enablementResource = this.erm.getResource();
        this.resourceResolver = this.enablementResource.getResourceResolver();
        this.session = this.resourceResolver.adaptTo(Session.class);
        this.userManager = this.enablementResource.adaptTo(UserManager.class);
        this.allowCatalog = this.erm.getAllowCatalogVisibility();
        this.allowAnonymous = this.erm.getAllowAnonymous();
        this.allowComment = this.erm.getAllowComments();
        this.allowRating = this.erm.getAllowRatings();
        this.allowSiteMemberComment = (this.allowCatalog || this.allowAnonymous) && this.allowComment;
        this.allowSiteMemberRating = (this.allowCatalog || this.allowAnonymous) && this.allowRating;
        this.allowEnrolleeComment = this.allowComment;
        this.allowEnrolleeRating = this.allowRating;
    }

    public void setUGCShadowPathACLs() throws RepositoryException {
        if (this.erm == null) {
            return;
        }
        if (!this.ugcShadowPathExists()) {
            return;
        }
        this.setSiteMembersAccess();
        this.setEnrolleeAccess();
    }

    public void setUGCShadowPathACLs(boolean isResourceInPrivateGroup, String memberGroupName) throws RepositoryException {
        if (this.erm == null) {
            return;
        }
        if (!this.ugcShadowPathExists()) {
            return;
        }
        this.setSiteMembersAccess(isResourceInPrivateGroup, memberGroupName);
        this.setEnrolleeAccess();
    }

    private void setSiteMembersAccess(boolean isResourceInPublicGroup, String memberGroupName) throws RepositoryException {
        if (isResourceInPublicGroup) {
            this.setSiteMembersAccess();
        } else {
            Authorizable groupSiteMembers = this.userManager.getAuthorizable(memberGroupName);
            Principal siteMembersPrincipal = groupSiteMembers.getPrincipal();
            if (this.allowSiteMemberComment || this.allowSiteMemberRating) {
                this.setACLAllow(siteMembersPrincipal, this.socialUGCShadowPath);
            } else {
                this.setACLDeny(siteMembersPrincipal, this.socialUGCShadowPath);
            }
            if (this.allowSiteMemberComment) {
                this.setACLAllow(siteMembersPrincipal, this.discussionPath);
            } else {
                this.setACLDeny(siteMembersPrincipal, this.discussionPath);
            }
            if (this.allowSiteMemberRating) {
                this.setACLAllow(siteMembersPrincipal, this.ratingPath);
            } else {
                this.setACLDeny(siteMembersPrincipal, this.ratingPath);
            }
        }
    }

    private boolean ugcShadowPathExists() {
        Resource ugc;
        EnablementSocialRatingsModel esrm;
        SocialResourceUtilities sru = this.resourceResolver.adaptTo(SocialResourceUtilities.class);
        if (sru == null) {
            throw new SocialException("Unable to fetch the SocialResourceUtilities");
        }
        Resource enablementSocialResource = this.erm.getSocial().getResource();
        this.socialUGCShadowPath = sru.resourceToACLPath(enablementSocialResource);
        if (this.socialUGCShadowPath == null || this.socialUGCShadowPath.isEmpty()) {
            return false;
        }
        EnablementSocialCommentsModel escm = this.erm.getSocial().getComments();
        if (escm != null) {
            Resource enablementCommentResource = escm.getResource();
            this.discussionPath = sru.resourceToACLPath(enablementCommentResource);
        }
        if ((esrm = this.erm.getSocial().getRatings()) != null) {
            Resource enablementRatingResource = esrm.getResource();
            this.ratingPath = sru.resourceToACLPath(enablementRatingResource);
        }
        return (ugc = this.resourceResolver.getResource(this.socialUGCShadowPath)) != null;
    }

    private void setSiteMembersAccess() throws RepositoryException {
        CommunityContext context = this.enablementResource.adaptTo(CommunityContext.class);
        UserUtils userUtils = this.resourceResolver.adaptTo(UserUtils.class);
        if (userUtils == null) {
            return;
        }
        String groupSiteMembersId = userUtils.getCommunitySiteGroupName(context, CommunityUserGroup.MEMBER);
        Authorizable groupSiteMembers = this.userManager.getAuthorizable(groupSiteMembersId);
        Principal siteMembersPrincipal = groupSiteMembers.getPrincipal();
        if (this.allowSiteMemberComment || this.allowSiteMemberRating) {
            this.setACLAllow(siteMembersPrincipal, this.socialUGCShadowPath);
        } else {
            this.setACLDeny(siteMembersPrincipal, this.socialUGCShadowPath);
        }
        if (this.allowSiteMemberComment) {
            this.setACLAllow(siteMembersPrincipal, this.discussionPath);
        } else {
            this.setACLDeny(siteMembersPrincipal, this.discussionPath);
        }
        if (this.allowSiteMemberRating) {
            this.setACLAllow(siteMembersPrincipal, this.ratingPath);
        } else {
            this.setACLDeny(siteMembersPrincipal, this.ratingPath);
        }
    }

    private void setEnrolleeAccess() throws RepositoryException {
        Group directEnrolleeGroup = this.erm.getResourceGroup("direct-enrollees");
        Group indirectEnrolleeGroup = this.erm.getResourceGroup("indirect-enrollees");
        if (directEnrolleeGroup != null && indirectEnrolleeGroup != null) {
            if (this.allowEnrolleeComment || this.allowEnrolleeRating) {
                this.setACLAllow(directEnrolleeGroup.getPrincipal(), this.socialUGCShadowPath);
                this.setACLAllow(indirectEnrolleeGroup.getPrincipal(), this.socialUGCShadowPath);
            } else {
                this.setACLDeny(directEnrolleeGroup.getPrincipal(), this.socialUGCShadowPath);
                this.setACLDeny(indirectEnrolleeGroup.getPrincipal(), this.socialUGCShadowPath);
            }
            if (this.allowEnrolleeComment) {
                this.setACLAllow(directEnrolleeGroup.getPrincipal(), this.discussionPath);
                this.setACLAllow(indirectEnrolleeGroup.getPrincipal(), this.discussionPath);
            } else {
                this.setACLDeny(directEnrolleeGroup.getPrincipal(), this.discussionPath);
                this.setACLDeny(indirectEnrolleeGroup.getPrincipal(), this.discussionPath);
            }
            if (this.allowEnrolleeRating) {
                this.setACLAllow(directEnrolleeGroup.getPrincipal(), this.ratingPath);
                this.setACLAllow(indirectEnrolleeGroup.getPrincipal(), this.ratingPath);
            } else {
                this.setACLDeny(directEnrolleeGroup.getPrincipal(), this.ratingPath);
                this.setACLDeny(indirectEnrolleeGroup.getPrincipal(), this.ratingPath);
            }
        }
    }

    private void setACLAllow(Principal principal, String path) throws RepositoryException {
        if (path == null || path.isEmpty() || this.resourceResolver.getResource(path) == null) {
            return;
        }
        AccessControlUtil.replaceAccessControlEntry(this.session, path, principal, userPrivileges, null, null, null);
    }

    private void setACLDeny(Principal principal, String path) throws RepositoryException {
        if (path == null || path.isEmpty() || this.resourceResolver.getResource(path) == null) {
            return;
        }
        AccessControlUtil.replaceAccessControlEntry(this.session, path, principal, null, userPrivileges, null, null);
    }
}

