/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.filelibrary.client.api.FileLibraryConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class AbstractFileLibraryConfiguration
extends AbstractCommentCollectionConfiguration
implements FileLibraryConfiguration {
    private boolean isTaggingAllowed;
    private final ValueMap fileLibraryProperties;
    private final Long maxFileSize;
    private final List<String> allowedFileTypes;

    public AbstractFileLibraryConfiguration(Resource cs) {
        super(cs);
        this.fileLibraryProperties = cs.adaptTo(ValueMap.class);
        this.isTaggingAllowed = this.fileLibraryProperties.get("allowTagging", false);
        this.maxFileSize = this.fileLibraryProperties.get("maxFileSize", 0x6400000L);
        this.allowedFileTypes = this.getAttachmentTypes(this.fileLibraryProperties);
        this.setAllowsDelete(true);
        this.setAllowsAttachment(true);
        this.setAllowsVoting(true);
        this.setRTEEnabled(true);
    }

    private List<String> getAttachmentTypes(ValueMap fileLibraryProperties) {
        String allowedFileTypes = (String)((Object)fileLibraryProperties.get("acceptFileTypes", String.class));
        if (StringUtils.isNotBlank(allowedFileTypes)) {
            return Arrays.asList(allowedFileTypes.split("\\s*,\\s*"));
        }
        return null;
    }

    @Override
    @JsonProperty(value="isTaggingAllowed")
    public boolean isTaggingAllowed() {
        return this.isTaggingAllowed;
    }

    @Override
    public List<String> getAllowedFileTypes() {
        return this.allowedFileTypes;
    }

    @Override
    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    protected ValueMap getFileLibraryProperties() {
        return this.fileLibraryProperties;
    }

    @Override
    public boolean useReferrer() {
        return true;
    }
}

