/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.gamification.badging.api;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.gamification.badging.api.Badge;
import com.adobe.cq.social.gamification.badging.api.utils.AttachmentUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.day.cq.commons.jcr.JcrUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractBadge
extends BaseSocialComponent
implements Badge {
    protected Resource badge;
    protected ResourceResolver resourceResolver;
    private Node resourceNode;

    public AbstractBadge(Resource resource, ClientUtilities clientUtilities) throws PersistenceException {
        super(resource, clientUtilities);
        this.clientUtils = clientUtilities;
        if (resource.isResourceType("social/gamification/components/hbs/badgecollection/badge") || resource.isResourceType("social/gamification/components/hbs/createbadge")) {
            this.badge = resource;
            this.resourceNode = this.badge.adaptTo(Node.class);
        }
    }

    public AbstractBadge(Resource resource, ClientUtilities clientUtilities, Badge badge) throws PersistenceException {
        super(resource, clientUtilities);
        Resource badgeResource;
        this.clientUtils = clientUtilities;
        this.resourceResolver = resource.getResourceResolver();
        this.badge = badgeResource = this.resourceResolver.getResource(badge.getPath());
        this.resourceNode = this.badge.adaptTo(Node.class);
    }

    public AbstractBadge(Resource resource, ClientUtilities clientUtilities, String nameHint) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException, PersistenceException {
        this(resource, clientUtilities, nameHint, resource.getPath(), resource.getResourceResolver());
        this.clientUtils = clientUtilities;
        this.resourceNode = this.badge.adaptTo(Node.class);
        this.resourceNode.setProperty("sling:resourceType", "social/gamification/components/hbs/badgecollection/badge");
    }

    public AbstractBadge(Resource resource, ClientUtilities clientUtilities, String title, String resourceGroupContainerPath, ResourceResolver resourceResolver) throws PersistenceException, RepositoryException {
        super(resource, clientUtilities);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("jcr:title", title);
        properties.put("jcr:primaryType", "nt:unstructured");
        Calendar c = Calendar.getInstance();
        properties.put("date-created", c);
        properties.put("date-modified", c);
        this.badge = resource = this.createUniqueResource(resourceResolver, resourceResolver.getResource(resourceGroupContainerPath), JcrUtil.createValidName(title), properties);
        this.resourceNode = this.badge.adaptTo(Node.class);
    }

    public Resource createUniqueResource(ResourceResolver resourceResolver, Resource parentResource, String nameHint, Map<String, Object> properties) throws PersistenceException {
        String resourceName = nameHint;
        int i = 1;
        while (parentResource.getChild(resourceName) != null) {
            resourceName = nameHint + i;
            ++i;
        }
        return resourceResolver.create(parentResource, resourceName, properties);
    }

    @Override
    public String getTitle() {
        if (this.badge == null) {
            return null;
        }
        String title = (String)this.badge.getValueMap().get("jcr:title");
        return title;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisplayName() {
        if (this.badge == null) {
            return null;
        }
        String displayName = (String)this.badge.getValueMap().get("displayName");
        return displayName;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        if (this.badge == null) {
            return null;
        }
        String description = (String)this.badge.getValueMap().get("jcr:description");
        return description;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getImageURL() {
        String badgeImageURL = null;
        if (this.badge == null) {
            return badgeImageURL;
        }
        Resource imageResource = this.getImageResource();
        if (imageResource != null) {
            badgeImageURL = imageResource.getPath();
        }
        return badgeImageURL;
    }

    @Override
    public void setImageURL(String imageURL) {
        this.badge.adaptTo(ModifiableValueMap.class).put("image", imageURL);
    }

    private Resource getImageResource() {
        Resource imageResource = null;
        if (this.badge == null) {
            return imageResource;
        }
        Iterable<Resource> children = this.badge.getChildren();
        for (Resource resource : children) {
            ValueMap valueMap = resource.getValueMap();
            String type = (String)valueMap.get("jcr:primaryType");
            if (!type.equalsIgnoreCase("nt:file")) continue;
            imageResource = resource;
            break;
        }
        return imageResource;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Attachment getImage() {
        Resource imageResource = this.getImageResource();
        if (imageResource == null) {
            return null;
        }
        Resource image = this.badge.getResourceResolver().getResource(imageResource.getPath());
        return this.getAttachment(image);
    }

    private Attachment getAttachment(Resource attResource) {
        if (attResource != null) {
            return AttachmentUtils.getAttachment(attResource, this.clientUtils);
        }
        return null;
    }

    @Override
    public String getPath() {
        String path = null;
        if (this.badge == null) {
            return path;
        }
        path = this.badge.getPath();
        return path;
    }

    @Override
    public Object getProperty(String key) {
        if (this.badge == null) {
            return null;
        }
        return this.badge.adaptTo(ValueMap.class).get(key);
    }

    @Override
    public void setTitle(String title) {
        this.badge.adaptTo(ModifiableValueMap.class).put("jcr:title", title);
    }

    @Override
    public void setDisplayName(String displayName) {
        if (displayName != null) {
            this.badge.adaptTo(ModifiableValueMap.class).put("displayName", displayName);
        }
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.badge.adaptTo(ModifiableValueMap.class).put("jcr:description", description);
        }
    }

    @Override
    public void setProperty(String key, Object value) throws RepositoryException {
        if (key != null) {
            this.badge.adaptTo(ModifiableValueMap.class).put(key, value);
        }
    }
}

